/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.utils;

import com.whatsapp.tws2.data.events.contact.Contact;
import com.whatsapp.tws2.data.events.contact.Phone;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class MarkdownContactFormatter {
    public static String formatContactMessageMD(List<Contact> contacts) {
        if (contacts == null || contacts.isEmpty()) {
            String empty = "**\ud83d\udcc7 Contactos (0)**\n\n_(sin registros)_";
            return empty;
        }
        String body = contacts.stream().map(MarkdownContactFormatter::buildContactBlock).collect(Collectors.joining("\n\n---\n\n"));
        String result = "**\ud83d\udcc7 Contactos (" + contacts.size() + ")**\n\n" + body;
        return result;
    }

    private static String buildContactBlock(Contact c) {
        String name = MarkdownContactFormatter.escapeMd((String)MarkdownContactFormatter.trimOrEmpty((String)(c.getName() != null ? c.getName().getFormattedName() : "")));
        StringBuilder phoneLines = new StringBuilder();
        if (c.getPhones() != null && !c.getPhones().isEmpty()) {
            for (Phone p : c.getPhones()) {
                String number = MarkdownContactFormatter.escapeMd((String)MarkdownContactFormatter.trimOrEmpty((String)p.getPhone()));
                String type = MarkdownContactFormatter.escapeMd((String)MarkdownContactFormatter.trimOrEmpty((String)p.getType()));
                phoneLines.append("- **N\u00famero:** ").append(number).append(" (**").append(type).append("**)  \n");
            }
        } else {
            phoneLines.append("- **N\u00famero:** _no disponible_  \n");
        }
        return "- **Nombre:** " + name + "  \n" + phoneLines.toString().trim();
    }

    private static String trimOrEmpty(String s) {
        return s == null ? "" : s.trim();
    }

    private static String escapeMd(String s) {
        return s.replace("\\", "\\\\").replace("*", "\\*").replace("_", "\\_").replace("`", "\\`").replace("|", "\\|").replace("~", "\\~").replace(">", "\\>").replace("<", "\\<");
    }
}

