/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.whatsapp.tws2.Repository.Services.CampaignMessageDAO;
import com.whatsapp.tws2.client.botpress.service.ApiBotpressService;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ExtractData;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.events.UserResponse;
import com.whatsapp.tws2.service.AsesorHiperService;
import com.whatsapp.tws2.service.CampaignService;
import com.whatsapp.tws2.service.LhiaProcessService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.ThinkAgentService;
import com.whatsapp.tws2.service.WebhookService;
import com.whatsapp.tws2.utils.MessageTypeUtils;
import com.whatsapp.tws2.utils.ResponseUtil;
import com.whatsapp.tws2.utils.StatusUtil;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private final StateConversationService stateConversationService;
    private final Environment env;
    private final ApiBotpressService apiBotpressService;
    private final ObjectMapper objectMapper;
    private final ResponseUtil responseUtil;
    private final LhiaProcessService lhiaProcessService;
    private final CampaignMessageDAO campaignMessageDAO;
    private final ApiWhatsAppService whatsAppService;
    private final ThinkAgentService thinkAgentService;
    private final AsesorHiperService asesorHiperService;
    private final CampaignService campaignService;

    public Mono<ResponseEntity<?>> handleWebhook(Object userResponse) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        Mono convertedRequestBody = this.convertToUserResponse(userResponse);
        return convertedRequestBody.flatMap(metaEvent -> {
            this.campaignService.notifyMessageStatuses(metaEvent).subscribe();
            log.info("continua el flujo del evento recibido");
            return this.convertToUserResponse(userResponse).flatMap(userBody -> this.stateConversationService.validateAndUpdateChatFromUserResponse(userBody).flatMap(status -> {
                log.info("status conversation> " + status);
                switch (status) {
                    case "NORMAL": {
                        return this.responseUtil.getMessage(userBody).flatMap(data -> {
                            String message;
                            log.info("WEBHOOK DATA {}", data);
                            if (data != null && data.getMessage() != null && ((message = data.getMessage().replaceAll(" ", "").toUpperCase()).equals(StatusUtil.ST_FINALIZAR) || message.contains("EL CHAT FUE CERRADO"))) {
                                data.setButtonId(StatusUtil.ST_FINALIZAR);
                                return this.lhiaProcessService.sendMessageLhiaSwitch(data).map(res -> ResponseEntity.ok().build());
                            }
                            return this.apiBotpressService.notifyWebHook(userResponse).map(res -> ResponseEntity.ok().build());
                        });
                    }
                    case "ASESOR": {
                        return this.asesorHiperService.flujoAsesor(userBody, defaultCallback, StatusUtil.ST_ASESOR);
                    }
                    case "CAMPANA": {
                        return this.responseUtil.getMessage(userBody).flatMap(data -> this.stateConversationService.getCallbackIdFromConversationId(data.getIdConversation()).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                            if (callbackId.startsWith(this.env.getProperty("tsa.canal.prefix"))) {
                                return this.handleCampaignCase(data);
                            }
                            return this.asesorHiperService.flujoAsesor(userBody, callbackId, StatusUtil.ST_CAMPANA);
                        }));
                    }
                    case "LHIA": {
                        return this.responseUtil.getMessage(userBody).flatMap(body -> {
                            log.info("WEBHOOK DATA TO LHIA {}", body);
                            if (body.getType().equals(MessageTypeUtils.TYPE_TEXT) || body.getType().equals(MessageTypeUtils.TYPE_INTERACTIVE)) {
                                log.info("IS A TEXT OR INTERACTIVE MESSAGE TO LHIA");
                                return this.lhiaProcessService.sendMessageLhiaSwitch(body).map(res -> ResponseEntity.ok().build());
                            }
                            return this.thinkAgentService.sendMessageToTAS(body).flatMap(res -> {
                                log.info("THINKAGENT RESPONSE {}", res);
                                TextMessageRequest textMessagaReq = new TextMessageRequest(body.getIdConversation(), StatusUtil.MSG_NOTIFICACION_CLIENTE_ARCHIVOS_ASESOR);
                                return this.whatsAppService.sendTextMessage(textMessagaReq).flatMap(metaRes -> {
                                    log.info("Mensaje enviado a WhatsApp: {}", metaRes);
                                    return Mono.just((Object)ResponseEntity.ok().build());
                                });
                            });
                        });
                    }
                    case "THINKAGENT": {
                        return this.responseUtil.getMessage(userBody).flatMap(body -> this.thinkAgentService.sendMessageToTAS(body).flatMap(res -> {
                            log.info("THINKAGENT RESPONSE {}", res);
                            return Mono.just((Object)ResponseEntity.ok().build());
                        }));
                    }
                }
                return Mono.just((Object)ResponseEntity.ok((Object)"OK"));
            })).onErrorResume(e -> {
                log.error("Error handling webhook: ", e);
                return Mono.just((Object)ResponseEntity.status((int)500).body((Object)"Internal Server Error"));
            });
        });
    }

    private Mono<UserResponse> convertToUserResponse(Object userResponse) {
        log.info("Converting user response: {}", userResponse);
        try {
            String json = this.objectMapper.writeValueAsString(userResponse);
            System.err.println("json: 1" + json);
            UserResponse userBody = (UserResponse)this.objectMapper.readValue(json, UserResponse.class);
            return Mono.just((Object)userBody);
        }
        catch (Exception e) {
            log.error("Error converting user response: ", (Throwable)e);
            return Mono.error((Throwable)new RuntimeException("Invalid user response format"));
        }
    }

    private Mono<ResponseEntity<?>> handleThinkAgentCase(ExtractData data) {
        return this.thinkAgentService.sendMessageToTAS(data).map(res -> {
            log.info("THINKAGENT RESPONSE: {}", res);
            return ResponseEntity.ok().build();
        });
    }

    private Mono<ResponseEntity<?>> handleCampaignCase(ExtractData data) {
        log.info("CAMPA\u00d1A, data {}", (Object)data);
        return this.campaignMessageDAO.findLastMessageTemplateByConversationId(data.getIdConversation()).flatMap(campaignMessage -> {
            if (!campaignMessage.isBlank()) {
                String messageOriginal;
                Object newMessageModified = "";
                String string = messageOriginal = data.getMessage() == null ? "" : data.getMessage();
                if (!data.getType().equals(MessageTypeUtils.TYPE_TEXT)) {
                    ExtractData textMessageModel = new ExtractData(data);
                    newMessageModified = "*Msg usuario:* [Archivo adjunto en el siguiente mensaje]\n*Campa\u00f1a:* " + campaignMessage;
                    textMessageModel.setMessage((String)newMessageModified);
                    textMessageModel.setType(MessageTypeUtils.TYPE_TEXT);
                    log.warn("EL MENSAJE DE CAMPANA CON ARCHIVOS ES: {}", (Object)data.getMessage());
                    return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(textMessageModel).delayElement(Duration.ofSeconds(3L)).flatMap(res -> this.handleThinkAgentCase(data)));
                }
                newMessageModified = "*Msg usuario:* " + messageOriginal + "\n*Campa\u00f1a:* " + campaignMessage;
                data.setMessage((String)newMessageModified);
                log.warn("EL MENSAJE DE CAMPANA ES: {}", (Object)data.getMessage());
            }
            return this.stateConversationService.updateStateByConversationId(data.getIdConversation(), StatusUtil.ST_THINKAGENT).then(this.handleThinkAgentCase(data));
        });
    }

    public WebhookServiceImpl(StateConversationService stateConversationService, Environment env, ApiBotpressService apiBotpressService, ObjectMapper objectMapper, ResponseUtil responseUtil, LhiaProcessService lhiaProcessService, CampaignMessageDAO campaignMessageDAO, ApiWhatsAppService whatsAppService, ThinkAgentService thinkAgentService, AsesorHiperService asesorHiperService, CampaignService campaignService) {
        this.stateConversationService = stateConversationService;
        this.env = env;
        this.apiBotpressService = apiBotpressService;
        this.objectMapper = objectMapper;
        this.responseUtil = responseUtil;
        this.lhiaProcessService = lhiaProcessService;
        this.campaignMessageDAO = campaignMessageDAO;
        this.whatsAppService = whatsAppService;
        this.thinkAgentService = thinkAgentService;
        this.asesorHiperService = asesorHiperService;
        this.campaignService = campaignService;
    }
}

