/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.StartConversationEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StartConversationEventsImpl
implements StartConversationEvents {
    private static final Logger log = LoggerFactory.getLogger(StartConversationEventsImpl.class);
    private final HistoryConversationItemService historyConversationItemService;

    public Mono<Void> startConversation(String conversationId, String nick) {
        log.info("Starting conversation with id: {}", (Object)conversationId);
        HistoryConversationItem historyConversationItem = HistoryConversationItem.startConversation((String)conversationId, (String)nick);
        return this.historyConversationItemService.save(historyConversationItem).doOnError(error -> log.error("Error saving conversation history for id {}: {}", (Object)conversationId, (Object)error.getMessage())).onErrorResume(error -> Mono.empty());
    }

    public StartConversationEventsImpl(HistoryConversationItemService historyConversationItemService) {
        this.historyConversationItemService = historyConversationItemService;
    }
}

