/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.service.RedirectConversationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class RedirectConversationServiceImpl
implements RedirectConversationService {
    private static final Logger log = LoggerFactory.getLogger(RedirectConversationServiceImpl.class);
    private final Environment env;

    public boolean isEventRedirect(String event) {
        if (event == null) {
            return false;
        }
        return (event = event.trim()).startsWith("redirect_conversation_to_tsa") || event.startsWith("redirect_conversation_to_hiper");
    }

    private String getCanalesTsa(String event) {
        switch (event) {
            case "redirect_conversation_to_tsa_ventas": {
                return this.env.getProperty("tsa.canal.callback.ventas");
            }
        }
        return this.env.getProperty("tsa.canal.callback.default");
    }

    private String getCanalesHiper(String event) {
        switch (event) {
            case "redirect_conversation_to_hiper_atencion_cliente": {
                return this.env.getProperty("canal.callback.atencion_cliente");
            }
            case "redirect_conversation_to_hiper_cobranzas": {
                return this.env.getProperty("canal.callback.cobranzas");
            }
            case "redirect_conversation_to_hiper_servicio_tecnico": {
                return this.env.getProperty("canal.callback.servicio_tecnico");
            }
        }
        return this.env.getProperty("lhiaflow.callback.atencion");
    }

    public String getChannelFromChangeEvent(String event) {
        if (event == null) {
            return this.env.getProperty("tsa.canal.callback.default");
        }
        if (event.startsWith("redirect_conversation_to_tsa".trim())) {
            return this.getCanalesTsa(event);
        }
        if (event.startsWith("redirect_conversation_to_hiper")) {
            return this.getCanalesHiper(event);
        }
        return null;
    }

    public RedirectConversationServiceImpl(Environment env) {
        this.env = env;
    }
}

