/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversation;
import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.HistoryConversationItemRepository;
import com.whatsapp.tws2.client.lhiaflow.LhiaFlowRequest;
import com.whatsapp.tws2.helpers.HistoryConversationItemHelper;
import com.whatsapp.tws2.service.HistoryConversationItemService;
import com.whatsapp.tws2.service.HistoryConversationService;
import com.whatsapp.tws2.tsa.data.PagedResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class HistoryConversationItemServiceImpl
implements HistoryConversationItemService {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationItemServiceImpl.class);
    private final HistoryConversationItemRepository historyConversationItemRepository;
    private final HistoryConversationService historyConversationService;
    private final HistoryConversationItemHelper historyConversationItemHelper;

    public Mono<String> getMessageByMetaId(String metaId) {
        return this.historyConversationItemRepository.findByMessageMetaId(metaId).map(HistoryConversationItem::getMessage).switchIfEmpty(Mono.just((Object)"No se encontr\u00f3 el mensaje respondido"));
    }

    public Mono<Void> save(HistoryConversationItem historyConversation) {
        log.info("Attempting to save HistoryConversation with createdAt: {}", (Object)historyConversation.getConversationId());
        return this.historyConversationItemRepository.save((Object)historyConversation).doOnSuccess(response -> log.info("UserResponse saved: {}", response)).then(this.historyConversationService.save(new HistoryConversation(historyConversation.getIdPlatform(), historyConversation.getNick(), historyConversation.getPlatform()))).onErrorResume(error -> {
            log.error("Error saving UserResponse: {}", (Object)error.getMessage());
            return Mono.empty();
        });
    }

    public Mono<PagedResponse<HistoryConversationItem>> getHistoryConversationItems(int page, int size, String sortDirection, String idPlatform) {
        Sort sort = "desc".equalsIgnoreCase(sortDirection) ? Sort.by((String[])new String[]{"createdAt"}).descending() : Sort.by((String[])new String[]{"createdAt"}).ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        return this.historyConversationItemRepository.countByIdPlatform(idPlatform).flatMap(arg_0 -> this.lambda$getHistoryConversationItems$3(size, page, idPlatform, (Pageable)pageable, arg_0));
    }

    public Flux<Map<String, Object>> getMessagesCountByDay(String startDateParam, String endDateParam) {
        return this.historyConversationItemHelper.getMessagesCountByDay(startDateParam, endDateParam);
    }

    public Mono<Map<String, Object>> getReportInformationConversations(String startDateParam, String endDateParam) {
        Mono usersSessionCountMono = this.historyConversationItemHelper.getUsersCountByDay(startDateParam, endDateParam);
        Mono messagesCountBot = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("BOT", "LHIA"));
        Mono messagesCountAssessor = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("ASESOR"));
        Mono messagesCountUser = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("USER"));
        return Mono.zip((Mono)usersSessionCountMono, (Mono)messagesCountBot, (Mono)messagesCountAssessor, (Mono)messagesCountUser).map(tuple -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userSession", tuple.getT1());
            result.put("messagesBot", tuple.getT2());
            result.put("messagesAssessor", tuple.getT3());
            result.put("messagesUser", tuple.getT4());
            return result;
        });
    }

    public Mono<Void> saveHistoryConversations(LhiaFlowRequest messageModel, String rol) {
        System.out.println(messageModel);
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(messageModel.getConversationChatId(), messageModel.getChannel(), (String)(messageModel.getMessage() != null ? messageModel.getMessage() : "Archivo de tipo [" + messageModel.getType() + "]"), rol.toUpperCase(), "CAMPANA", messageModel.getNick());
        return this.save(userHistoryConversation).then();
    }

    public HistoryConversationItemServiceImpl(HistoryConversationItemRepository historyConversationItemRepository, HistoryConversationService historyConversationService, HistoryConversationItemHelper historyConversationItemHelper) {
        this.historyConversationItemRepository = historyConversationItemRepository;
        this.historyConversationService = historyConversationService;
        this.historyConversationItemHelper = historyConversationItemHelper;
    }

    private /* synthetic */ Mono lambda$getHistoryConversationItems$3(int size, int page, String idPlatform, Pageable pageable, Long totalElements) {
        int totalPages = (int)Math.ceil((double)totalElements.longValue() / (double)size);
        boolean isLast = page + 1 >= totalPages;
        return this.historyConversationItemRepository.findAllByIdPlatform(idPlatform, pageable).collectList().map(content -> new PagedResponse(content, page, size, totalElements.longValue(), totalPages, isLast));
    }
}

