/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.service.impl;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.service.ChatMarkdownService;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ChatMarkdownServiceImpl
implements ChatMarkdownService {
    private static final Logger log = LoggerFactory.getLogger(ChatMarkdownServiceImpl.class);

    public Mono<String> generarConversacionMarkdown(String titulo, List<HistoryConversationItem> mensajes) {
        Collections.reverse(mensajes);
        StringBuilder sb = new StringBuilder();
        sb.append("**\ud83d\udcac Conversaci\u00f3n: ").append(titulo).append("**\n\n");
        for (HistoryConversationItem msg : mensajes) {
            sb.append("> **").append(msg.getRol()).append(":** ").append(msg.getMessage()).append("\n\n");
        }
        return Mono.just((Object)sb.toString().trim());
    }

    public Mono<String> generarConversacionSinMarkdown(String titulo, List<HistoryConversationItem> mensajes) {
        Collections.reverse(mensajes);
        StringBuilder sb = new StringBuilder();
        sb.append("**\ud83d\udcac Conversaci\u00f3n: ").append(titulo).append("**\n\n");
        for (HistoryConversationItem msg : mensajes) {
            sb.append("> ").append(msg.getRol()).append(": ").append(msg.getMessage()).append("\n\n");
        }
        return Mono.just((Object)sb.toString().trim());
    }
}

