/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.DTO.DailyCountDTO;
import com.whatsapp.tws2.Documents.CampaignModel;
import com.whatsapp.tws2.Documents.ImagenModel;
import com.whatsapp.tws2.client.whatsapp.service.ApiWhatsAppService;
import com.whatsapp.tws2.data.ConversationSummaryResponse;
import com.whatsapp.tws2.data.DateConversation;
import com.whatsapp.tws2.data.FileMessageRequestFromHiper;
import com.whatsapp.tws2.data.TextMessageRequest;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplate;
import com.whatsapp.tws2.data.templatesMeta.WhatsAppTemplateRequest;
import com.whatsapp.tws2.service.CampaignService;
import com.whatsapp.tws2.service.HiperService;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.TemplateService;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/api"})
public class WhatsappController {
    private static final Logger log = LoggerFactory.getLogger(WhatsappController.class);
    private final StateConversationService stateConversationService;
    private final ApiWhatsAppService whatsAppService;
    private final TemplateService templateService;
    private final CampaignService campaignService;
    private final HiperService hiperService;

    @PostMapping(value={"/asesor"})
    public Mono<Void> receiveTemplateMessage(@RequestBody Object request) {
        return this.hiperService.receiveTemplateMessageFromHiper(request);
    }

    @GetMapping(value={"/test"})
    public Mono<?> test() {
        HashMap<String, String> successResponse = new HashMap<String, String>();
        log.info("ENTRA AL SERVICIO CONSULTADO");
        successResponse.put("status", "success");
        return Mono.just(successResponse);
    }

    @PostMapping(value={"/send-message"})
    public Mono<ResponseEntity<Map<String, Object>>> sendTextMessageTestHiper(@RequestBody TextMessageRequest req) {
        log.info("Sending message from hiper {}", (Object)req.getPhoneNumber());
        return this.stateConversationService.validateAndUpdateChatFromApi(req).doOnNext(estado -> log.warn("\n\n\nEstado de la conversaci\u00f3n: " + estado + "\n\n\n")).flatMap(estado -> this.whatsAppService.sendTextMessage(req)).map(response -> {
            HashMap<String, String> successResponse = new HashMap<String, String>();
            successResponse.put("status", "success");
            successResponse.put("message", "Mensaje de texto enviado correctamente.");
            return ResponseEntity.ok(successResponse);
        }).onErrorResume(e -> {
            log.error("Failed to send text message: {}", (Object)e.getMessage());
            HashMap<String, String> errorResponse = new HashMap<String, String>();
            errorResponse.put("status", "error");
            errorResponse.put("error", "Error al enviar el mensaje, contacte al administrador.");
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse));
        });
    }

    @PostMapping(value={"/sendText"})
    public Mono<ResponseEntity<String>> sendTextMessage(@RequestBody TextMessageRequest req) {
        return this.hiperService.sendTextMessage(req);
    }

    @PostMapping(value={"/sendImage"})
    public Mono<ResponseEntity<String>> sendImageMessageReactive(@RequestBody FileMessageRequestFromHiper imageMessageRequest) {
        return this.hiperService.sendImageMessageReactive(imageMessageRequest);
    }

    @PostMapping(value={"/sendVideo"})
    public Mono<ResponseEntity<String>> sendVideoMessageReactive(@RequestBody FileMessageRequestFromHiper imageMessageRequest) {
        return this.hiperService.sendVideoMessageReactive(imageMessageRequest);
    }

    @PostMapping(value={"/sendDocument"})
    public Mono<ResponseEntity<String>> sendDocumentMessageReactive(@RequestBody FileMessageRequestFromHiper imageMessageRequest) {
        return this.hiperService.sendDocumentMessageReactive(imageMessageRequest);
    }

    @GetMapping(value={"/templates"})
    public Mono<List<WhatsAppTemplate>> getTemplates() throws Exception {
        return this.templateService.getTemplates();
    }

    @GetMapping(value={"/templates/{id}"})
    public Mono<WhatsAppTemplate> getTemplateById(@PathVariable(value="id", required=true) String id) {
        return this.templateService.getTemplateById(id);
    }

    @PostMapping(value={"/send-template"})
    public Mono<Void> sendTemplate(@RequestBody WhatsAppTemplateRequest request) {
        return this.templateService.sendMessageFromTemplate(request);
    }

    @PostMapping(value={"/analytics-conversation"}, produces={"application/json"})
    public Mono<ConversationSummaryResponse> getConversationSummary(@RequestBody DateConversation dateConversation) {
        return this.templateService.getConversationSummary(dateConversation.getFecha_inicio(), dateConversation.getFecha_fin());
    }

    @GetMapping(value={"/conversations-incidents"})
    public Mono<List<CampaignModel>> getAllConversationIncident() {
        return this.templateService.getAllConversationIncident();
    }

    @PostMapping(value={"/imagen-url"})
    public Mono<ImagenModel> guardarImagen(@RequestBody ImagenModel body) {
        return this.templateService.guardarUrlImagen(body.getIdImagen(), body.getUrlImagen());
    }

    @GetMapping(value={"/imagen-url/{id}"})
    public Mono<String> obtenerImagen(@PathVariable String id) {
        return this.templateService.obtenerIdImagen(id);
    }

    @PostMapping(value={"/campaigns-count"})
    public Mono<List<DailyCountDTO>> getAllCampaigns(@RequestBody Map<String, String> body) {
        LocalDate initDate = LocalDate.parse(body.get("initDate"));
        LocalDate endDate = LocalDate.parse(body.get("endDate"));
        return this.campaignService.obtenerListaDeCompanasPorFecha(initDate, endDate);
    }

    public WhatsappController(StateConversationService stateConversationService, ApiWhatsAppService whatsAppService, TemplateService templateService, CampaignService campaignService, HiperService hiperService) {
        this.stateConversationService = stateConversationService;
        this.whatsAppService = whatsAppService;
        this.templateService = templateService;
        this.campaignService = campaignService;
        this.hiperService = hiperService;
    }
}

