/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.controller;

import com.whatsapp.tws2.data.state.UpdateStateConversationRequest;
import com.whatsapp.tws2.service.StateConversationService;
import com.whatsapp.tws2.service.StateValidationService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/state"})
public class StateController {
    private static final Logger log = LoggerFactory.getLogger(StateController.class);
    private final StateConversationService stateConversationService;
    private final StateValidationService stateValidationService;
    private final Environment env;

    @GetMapping(value={"/userStateConversation/{conversationId}"})
    public Mono<Map<String, Object>> getUserStateConversation(@PathVariable String conversationId) {
        return this.stateConversationService.getStatusCoonversation(conversationId).flatMap(status -> {
            Map<String, String> map = Map.of("conversationId", conversationId, "event", "status", "status", status);
            return Mono.just(map);
        });
    }

    @PostMapping(value={"/updateStateCloseConversation"})
    public Mono<ResponseEntity<Void>> updateStateCloseConversation(@RequestParam String conversationId) {
        return this.stateConversationService.updateStateCloseConversation(conversationId).thenReturn((Object)ResponseEntity.ok().build());
    }

    @PostMapping(value={"/updateStateConversation"})
    public Mono<ResponseEntity<Void>> updateStateConversation(@RequestBody UpdateStateConversationRequest body) {
        log.info("updating status conversation {}", (Object)body);
        String conversationId = body.getConversationId();
        String event = body.getEvent();
        if (conversationId != null && event != null) {
            return this.stateValidationService.validateState(body).then(Mono.just((Object)ResponseEntity.ok().build()));
        }
        return Mono.just((Object)ResponseEntity.badRequest().build());
    }

    public StateConversationService getStateConversationService() {
        return this.stateConversationService;
    }

    public StateValidationService getStateValidationService() {
        return this.stateValidationService;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateController)) {
            return false;
        }
        StateController other = (StateController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        StateConversationService this$stateConversationService = this.getStateConversationService();
        StateConversationService other$stateConversationService = other.getStateConversationService();
        if (this$stateConversationService == null ? other$stateConversationService != null : !this$stateConversationService.equals(other$stateConversationService)) {
            return false;
        }
        StateValidationService this$stateValidationService = this.getStateValidationService();
        StateValidationService other$stateValidationService = other.getStateValidationService();
        if (this$stateValidationService == null ? other$stateValidationService != null : !this$stateValidationService.equals(other$stateValidationService)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StateConversationService $stateConversationService = this.getStateConversationService();
        result = result * 59 + ($stateConversationService == null ? 43 : $stateConversationService.hashCode());
        StateValidationService $stateValidationService = this.getStateValidationService();
        result = result * 59 + ($stateValidationService == null ? 43 : $stateValidationService.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "StateController(stateConversationService=" + this.getStateConversationService() + ", stateValidationService=" + this.getStateValidationService() + ", env=" + this.getEnv() + ")";
    }

    public StateController(StateConversationService stateConversationService, StateValidationService stateValidationService, Environment env) {
        this.stateConversationService = stateConversationService;
        this.stateValidationService = stateValidationService;
        this.env = env;
    }
}

