/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.client.tsa.service;

import com.whatsapp.tws2.client.tsa.TsaApiService;
import com.whatsapp.tws2.client.tsa.models.ResponseMessageEvent;
import com.whatsapp.tws2.data.tsa.RequestMessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaApiServiceImpl
implements TsaApiService {
    private static final Logger log = LoggerFactory.getLogger(TsaApiServiceImpl.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<ResponseMessageEvent> sendMesssageToAsesor(RequestMessageModel data, String callbackId) {
        log.info("Sending message to THINK SERVICE AGENT");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        data.setCallbackUrl(this.env.getProperty("tsa.api.callback.url"));
        String API_URL = this.env.getProperty("tsa.api.url.messages").replace("{channel}", callbackId);
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(headerName, token);
        log.info("CONNECTING TO TSA {}", (Object)data);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)data).retrieve().bodyToMono(ResponseMessageEvent.class).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<String> closeConvesation(String identifier) {
        log.info("Closing conversation");
        String accountId = this.env.getProperty("tsa.api.accountid");
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.close.conversation.url").replace("{identifier}", identifier).replace("{accountId}", accountId);
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.add(headerName, token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().put().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response webhook close event {}", response);
            return Mono.just((Object)response);
        });
    }

    public TsaApiServiceImpl(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

