/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.tws2.Repository;

import com.whatsapp.tws2.Documents.HistoryConversationItem;
import com.whatsapp.tws2.Repository.HistoryConversationItemRepository;
import com.whatsapp.tws2.service.ChatMarkdownService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Repository
public class HistoryConversationItemReactive {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationItemReactive.class);
    private final HistoryConversationItemRepository historyConversationItemRepository;
    private final ChatMarkdownService chatMarkdownService;

    private Flux<HistoryConversationItem> obtenerHistorialLimitado(String idPlatform, String chatEvent) {
        LocalDateTime hace24Horas = LocalDateTime.now().minusHours(24L);
        return this.historyConversationItemRepository.findByIdPlatformAndCreatedAtAfterOrderByCreatedAtDesc(idPlatform, hace24Horas).collectList().flatMapMany(lista -> {
            ArrayList<HistoryConversationItem> resultado = new ArrayList<HistoryConversationItem>();
            for (HistoryConversationItem mensaje : lista) {
                resultado.add(mensaje);
                if (mensaje.getMessage() == null || !mensaje.getMessage().toUpperCase().startsWith(chatEvent)) continue;
                break;
            }
            return Flux.fromIterable(resultado);
        });
    }

    public Mono<String> getConversationHistoryOnMarkDownEstructure(String title, String conversationId) {
        return this.obtenerHistorialLimitado(conversationId, "EL CHAT FUE ACEPTADO").collectList().flatMap(mensajes -> {
            if (mensajes.isEmpty()) {
                return Mono.empty();
            }
            return this.chatMarkdownService.generarConversacionMarkdown(title, mensajes);
        }).onErrorResume(e -> {
            log.error("Error al obtener el historial limitado", e);
            return Mono.just((Object)"NO SE PUDO OBTENER EL HISTORIAL");
        });
    }

    public Mono<String> getConversationHistoryEstructure(String title, String conversationId) {
        return this.obtenerHistorialLimitado(conversationId, "EL CHAT FUE ACEPTADO").collectList().flatMap(mensajes -> {
            if (mensajes.isEmpty()) {
                return Mono.empty();
            }
            return this.chatMarkdownService.generarConversacionSinMarkdown(title, mensajes);
        }).onErrorResume(e -> {
            log.error("Error al obtener el historial limitado", e);
            return Mono.just((Object)"NO SE PUDO OBTENER EL HISTORIAL");
        });
    }

    public HistoryConversationItemReactive(HistoryConversationItemRepository historyConversationItemRepository, ChatMarkdownService chatMarkdownService) {
        this.historyConversationItemRepository = historyConversationItemRepository;
        this.chatMarkdownService = chatMarkdownService;
    }
}

