/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.messenger.marci.client.botpress.service.ApiBotpressService;
import com.messenger.marci.client.lhiaflow.LhiaFlowRequest;
import com.messenger.marci.client.lhiaflow.service.ApiLhiaFLowService;
import com.messenger.marci.messenger.data.messages.extractData.ExtractDataEntry;
import com.messenger.marci.messenger.service.MessagesMessengerService;
import com.messenger.marci.service.HistoryConversationItemService;
import com.messenger.marci.service.LhiaProcessService;
import com.messenger.marci.service.StateConversationService;
import com.messenger.marci.service.ThinkAgentService;
import com.messenger.marci.service.WebhookService;
import com.messenger.marci.utils.MessageTypeUtils;
import com.messenger.marci.utils.PlatformEnum;
import com.messenger.marci.utils.StatusUtil;
import com.messenger.marci.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class WebhookServiceImpl
implements WebhookService {
    private static final Logger log = LoggerFactory.getLogger(WebhookServiceImpl.class);
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationItemService;
    private final ApiBotpressService apiBotpressService;
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final LhiaProcessService lhiaProcessService;
    private final MessagesMessengerService messagesMessengerService;
    private final ThinkAgentService thinkAgentService;
    private final Environment env;

    public Mono<ResponseEntity<?>> identificarWebhook(JsonNode bodyWebhookMessenger) {
        try {
            log.info("hook {}", (Object)bodyWebhookMessenger);
            List entries = Utils.parseEntries((JsonNode)bodyWebhookMessenger);
            List entriesFilterDeliveredMessages = entries.stream().filter(entry -> !MessageTypeUtils.DELIVERY_TYPE.equals(entry.getMessageType())).collect(Collectors.toList());
            if (entriesFilterDeliveredMessages.isEmpty()) {
                log.info("ESTOS MENSAJES FUERON IGNORADOS PEUSTO QUE SON SOLO CONFIRMACIONES DE ENTREGA DE MENSAJES");
                Map<String, Boolean> map = Map.of("status", "ok", "empty", true);
                return Mono.just((Object)ResponseEntity.ok(map));
            }
            log.warn("Objetos mapeados: {}", (Object)entries);
            return this.entryMessageBroker(entriesFilterDeliveredMessages, bodyWebhookMessenger).flatMap(response -> {
                log.info("Respuesta: {}", response);
                Map<String, String> map = Map.of("status", "ok");
                return Mono.just((Object)ResponseEntity.ok(map));
            });
        }
        catch (Exception e) {
            log.error("Error al procesar el mensaje", (Throwable)e);
            return Mono.just((Object)ResponseEntity.ok((Object)"Error al procesar el mensaje"));
        }
    }

    private Mono<ResponseEntity<?>> entryMessageBroker(List<ExtractDataEntry> entries, JsonNode bodyWebhookMessenger) {
        return Flux.fromIterable(entries).flatMap(entry -> this.stateConversationService.validateConversationAndGetStatusConversation(entry).flatMap(status -> {
            log.info("Status: {}", status);
            return this.handleStatusSwitch(status, entry, bodyWebhookMessenger).then(this.historyConversationItemService.saveConversationFromWebhookMessenger(entry, status));
        }).onErrorResume(e -> {
            log.error("Error procesando entrada {}: {}", new Object[]{entry, e.getMessage(), e});
            return Mono.empty();
        })).collectList().map(ResponseEntity::ok);
    }

    private Mono<ExtractDataEntry> handleStatusSwitch(String status, ExtractDataEntry data, JsonNode bodyWebhookMessenger) {
        switch (status) {
            case "NORMAL": {
                return this.handleNormalCase(bodyWebhookMessenger);
            }
            case "ASESOR": {
                return this.handleAsesorCase(data);
            }
            case "LHIA": {
                return this.handleLhiaCase(data);
            }
            case "FINALIZAR": {
                return this.handleFinalizarCase(data);
            }
            case "THINKAGENT": {
                return this.handleThinkAgentCase(data);
            }
        }
        return Mono.just((Object)data);
    }

    private Mono<ExtractDataEntry> handleThinkAgentCase(ExtractDataEntry data) {
        return this.thinkAgentService.sendMessageToTAS(data).flatMap(res -> {
            log.info("THINKAGENT RESPONSE {}", res);
            return Mono.just((Object)data);
        });
    }

    private Mono<ExtractDataEntry> handleFinalizarCase(ExtractDataEntry data) {
        log.info("Finalizando conversaci\u00f3n");
        return this.messagesMessengerService.sendTextMessage(data.getMessaging().getSenderId(), StatusUtil.MSG_FINALIZAR_CONVERSACION).flatMap(response -> {
            log.info("Respuesta de META: {}", response);
            return this.stateConversationService.updateConversation(data.getMessaging().getSenderId(), StatusUtil.ST_NORMAL, null).flatMap(conversation -> Mono.just((Object)data));
        });
    }

    private Mono<ExtractDataEntry> handleLhiaCase(ExtractDataEntry data) {
        log.info("Notificando mensaje a Lhia");
        return this.lhiaProcessService.sendMessageLhiaSwitch(data).flatMap(response -> {
            log.info("Respuesta de Lhia: {}", response);
            return Mono.just((Object)data);
        });
    }

    private Mono<ExtractDataEntry> handleNormalCase(JsonNode bodyWebhookMessenger) {
        log.info("Notificando mensaje a Botpress");
        String API_URL = this.env.getProperty("botpress.webhook.messenger");
        return this.apiBotpressService.notifyWebHook((Object)bodyWebhookMessenger, API_URL).flatMap(response -> {
            log.info("Respuesta de Botpress: {}", response);
            return Mono.empty();
        });
    }

    private Mono<ExtractDataEntry> handleAsesorCase(ExtractDataEntry data) {
        log.info("Notificando mensaje a LhiaFlow");
        String defaultCallbackId = this.env.getProperty("tsa.canal.callback.atencion");
        String messageType = data.getMessageType();
        return this.stateConversationService.getCallbackIdFromConversationId(data.getMessaging().getSenderId()).defaultIfEmpty((Object)defaultCallbackId).flatMap(callbackId -> {
            log.info("CallbackId: {}", callbackId);
            return this.historyConversationItemService.extractMessageFromDataEntry(data).flatMap(message -> this.historyConversationItemService.getNameFromApiMeta(data.getMessaging().getSenderId()).flatMap(nick -> {
                if (messageType.equals(MessageTypeUtils.MEDIA_MESSAGE)) {
                    List files = data.getMessaging().getFiles();
                    return Flux.fromIterable((Iterable)files).flatMap(file -> {
                        LhiaFlowRequest lhiaFlowRequest = LhiaFlowRequest.builder().channel(PlatformEnum.MESSENGER.getPlatform()).nick(nick).conversationChatId(data.getMessaging().getSenderId()).callbackId(callbackId).type(file.getType()).file(file.getUrl()).build();
                        return this.apiLhiaFLowService.sendMesssageToAsesor(lhiaFlowRequest).flatMap(response -> {
                            log.info("Respuesta de LhiaFlow: {}", response);
                            return Mono.just((Object)data);
                        });
                    }).collectList().thenReturn((Object)data);
                }
                LhiaFlowRequest lhiaFlowRequest = LhiaFlowRequest.builder().channel(PlatformEnum.MESSENGER.getPlatform()).nick(nick).conversationChatId(data.getMessaging().getSenderId()).callbackId(callbackId).type("text").message(message).build();
                return this.apiLhiaFLowService.sendMesssageToAsesor(lhiaFlowRequest).flatMap(response -> {
                    log.info("Respuesta de LhiaFlow: {}", response);
                    return Mono.just((Object)data);
                });
            }));
        });
    }

    public WebhookServiceImpl(StateConversationService stateConversationService, HistoryConversationItemService historyConversationItemService, ApiBotpressService apiBotpressService, ApiLhiaFLowService apiLhiaFLowService, LhiaProcessService lhiaProcessService, MessagesMessengerService messagesMessengerService, ThinkAgentService thinkAgentService, Environment env) {
        this.stateConversationService = stateConversationService;
        this.historyConversationItemService = historyConversationItemService;
        this.apiBotpressService = apiBotpressService;
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.lhiaProcessService = lhiaProcessService;
        this.messagesMessengerService = messagesMessengerService;
        this.thinkAgentService = thinkAgentService;
        this.env = env;
    }
}

