/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.service.impl;

import com.messenger.marci.Documents.HistoryConversationItem;
import com.messenger.marci.Repository.Services.ConversationDAO;
import com.messenger.marci.client.tsa.TsaApiService;
import com.messenger.marci.data.tsa.RequestMessageModel;
import com.messenger.marci.messenger.data.messages.extractData.ExtractDataEntry;
import com.messenger.marci.messenger.service.MessagesMessengerService;
import com.messenger.marci.service.HistoryConversationItemService;
import com.messenger.marci.service.StateConversationService;
import com.messenger.marci.service.ThinkAgentService;
import com.messenger.marci.utils.MessageTypeUtils;
import com.messenger.marci.utils.PlatformEnum;
import com.messenger.marci.utils.StatusUtil;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ThinkAgentServiceImpl
implements ThinkAgentService {
    private static final Logger log = LoggerFactory.getLogger(ThinkAgentServiceImpl.class);
    private final TsaApiService tsaApiService;
    private final StateConversationService stateConversationService;
    private final HistoryConversationItemService historyConversationItemService;
    private final Environment env;
    private final MessagesMessengerService messagesMessengerService;
    private final ConversationDAO conversationDAO;

    public Mono<ResponseEntity<String>> sendMessageToTAS(ExtractDataEntry dataMessageMeta) {
        log.info("Data message meta: {}", (Object)dataMessageMeta);
        String userId = dataMessageMeta.getMessaging().getSenderId();
        RequestMessageModel requestMessageModel = new RequestMessageModel();
        RequestMessageModel.Payload payload = new RequestMessageModel.Payload();
        requestMessageModel.setType("message");
        requestMessageModel.setId(userId);
        requestMessageModel.setPayload(payload);
        requestMessageModel.setChannel(PlatformEnum.MESSENGER.getPlatform());
        if (dataMessageMeta.getMessageType().equals(MessageTypeUtils.TEXT_MESSAGE) || dataMessageMeta.getMessageType().equals(MessageTypeUtils.REPLY_MESSAGE)) {
            requestMessageModel.getPayload().setType(MessageTypeUtils.TEXT_TYPE);
            requestMessageModel.getPayload().setContent(dataMessageMeta.getMessaging().getMessage());
            return this.sendMessage(dataMessageMeta, requestMessageModel);
        }
        List files = dataMessageMeta.getMessaging().getFiles();
        return Flux.fromIterable((Iterable)files).flatMap(file -> {
            RequestMessageModel clonado = requestMessageModel.toBuilder().payload(requestMessageModel.getPayload().toBuilder().build()).build();
            clonado.getPayload().setType(MessageTypeUtils.TYPE_FILE);
            clonado.getPayload().setContent(file.getUrl());
            return this.sendMessage(dataMessageMeta, clonado);
        }).then(Mono.just((Object)ResponseEntity.ok((Object)"Archivos enviados correctamente")));
    }

    private Mono<ResponseEntity<String>> sendMessage(ExtractDataEntry dataMessageMeta, RequestMessageModel requestMessageModel) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.default");
        String userId = dataMessageMeta.getMessaging().getSenderId();
        return this.conversationDAO.getNameByConversationId(userId).switchIfEmpty(Mono.just((Object)"N/A")).flatMap(name -> {
            requestMessageModel.setNick(name);
            if (dataMessageMeta.getMessaging().getReplyTo() != null) {
                return this.historyConversationItemService.getMessageByMetaId(dataMessageMeta.getMessaging().getReplyTo()).flatMap(message -> {
                    log.info("The message replied is: {}", message);
                    requestMessageModel.getPayload().setRepliedMessage(message);
                    return this.conversationDAO.getCallbackByConversationId(userId).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId));
                });
            }
            return this.conversationDAO.getCallbackByConversationId(userId).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> this.sendMessageToTAS(requestMessageModel, callbackId));
        });
    }

    public Mono<ResponseEntity<String>> sendMessageToMessengerFromTSA(RequestMessageModel requestMessageModel) {
        return this.processMessageToTsa(requestMessageModel);
    }

    private Mono<String> updateAndSaveConversation(HistoryConversationItem historyConversationItem, String newState) {
        return this.stateConversationService.updateStateByConversationId(historyConversationItem.getIdPlatform(), newState).then(this.historyConversationItemService.save(historyConversationItem)).thenReturn((Object)historyConversationItem.getMessageMetaId());
    }

    private Mono<ResponseEntity<String>> processMessageToTsa(RequestMessageModel requestMessageModel) {
        String userId = requestMessageModel.getId();
        String messageType = requestMessageModel.getPayload().getType();
        HistoryConversationItem historyConversationItem = HistoryConversationItem.createNewRegisterForTSA((String)requestMessageModel.getId(), (String)requestMessageModel.getChannel(), (String)requestMessageModel.getPayload().getContent(), (String)StatusUtil.ST_ASESOR, (String)StatusUtil.ST_THINKAGENT, (String)requestMessageModel.getNick(), (String)messageType);
        switch (messageType) {
            case "text": {
                String textMessage = requestMessageModel.getPayload().getContent();
                if (textMessage.toUpperCase().contains("POR FAVOR CALIFICA ESTA CONVERSACI")) {
                    return this.messagesMessengerService.sendTextMessage(userId, textMessage).flatMap(messageMetaId -> {
                        log.info("Meta message id: {}", messageMetaId);
                        historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
                        return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_NORMAL).thenReturn(messageMetaId);
                    });
                }
                if (textMessage.toUpperCase().contains("ESTE MENSAJE SE HA ELIMINADO")) {
                    log.info("Mensaje de eliminaci\u00f3n ignorado");
                    return Mono.just((Object)ResponseEntity.ok((Object)UUID.randomUUID().toString()));
                }
                return this.messagesMessengerService.sendTextMessage(userId, textMessage).flatMap(messageMetaId -> {
                    log.info("Meta message id: {}", messageMetaId);
                    historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
                    return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_THINKAGENT).thenReturn(messageMetaId);
                });
            }
            case "image": {
                return this.messagesMessengerService.sendIndividualFileMessage(userId, MessageTypeUtils.IMAGE_TYPE, requestMessageModel.getPayload().getContent()).flatMap(messageMetaId -> {
                    log.info("Meta message id: {}", messageMetaId);
                    historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
                    return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_THINKAGENT).thenReturn(messageMetaId);
                });
            }
            case "video": {
                return this.messagesMessengerService.sendIndividualFileMessage(userId, MessageTypeUtils.VIDEO_TYPE, requestMessageModel.getPayload().getContent()).flatMap(messageMetaId -> {
                    log.info("Meta message id: {}", messageMetaId);
                    historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
                    return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_THINKAGENT).thenReturn(messageMetaId);
                });
            }
            case "document": {
                return this.messagesMessengerService.sendIndividualFileMessage(userId, MessageTypeUtils.DOCUMENT_TYPE, requestMessageModel.getPayload().getContent()).flatMap(messageMetaId -> {
                    log.info("Meta message id: {}", messageMetaId);
                    historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
                    return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_THINKAGENT).thenReturn(messageMetaId);
                });
            }
            case "audio": {
                return this.messagesMessengerService.sendIndividualFileMessage(userId, MessageTypeUtils.AUDIO_TYPE, requestMessageModel.getPayload().getContent()).flatMap(messageMetaId -> {
                    log.info("Meta message id: {}", messageMetaId);
                    historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
                    return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_THINKAGENT).thenReturn(messageMetaId);
                });
            }
        }
        String unknowTextMessage = requestMessageModel.getPayload().getContent();
        return this.messagesMessengerService.sendTextMessage(userId, unknowTextMessage).flatMap(messageMetaId -> {
            log.info("Meta message id: {}", messageMetaId);
            historyConversationItem.setMessageMetaId((String)messageMetaId.getBody());
            return this.updateAndSaveConversation(historyConversationItem, StatusUtil.ST_THINKAGENT).thenReturn(messageMetaId);
        });
    }

    public Mono<ResponseEntity<String>> sendMessageToTAS(RequestMessageModel requestMessageModel, String callbackId) {
        return this.tsaApiService.sendMesssageToAsesor(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent"));
        });
    }

    public Mono<ResponseEntity<String>> redirectLhiaConversationToTSA(RequestMessageModel requestMessageModel) {
        String status = StatusUtil.ST_THINKAGENT;
        String callbackId = this.env.getProperty("tsa.canal.callback.ventas");
        requestMessageModel.setChannel(PlatformEnum.MESSENGER.getPlatform());
        return this.sendMessageToTAS(requestMessageModel, callbackId).flatMap(response -> {
            log.info("response webhook {}", response);
            return this.stateConversationService.updateStateByConversationId(requestMessageModel.getId(), status).then(Mono.just((Object)ResponseEntity.ok((Object)"Message sent to ThinkAgent")));
        });
    }

    public ThinkAgentServiceImpl(TsaApiService tsaApiService, StateConversationService stateConversationService, HistoryConversationItemService historyConversationItemService, Environment env, MessagesMessengerService messagesMessengerService, ConversationDAO conversationDAO) {
        this.tsaApiService = tsaApiService;
        this.stateConversationService = stateConversationService;
        this.historyConversationItemService = historyConversationItemService;
        this.env = env;
        this.messagesMessengerService = messagesMessengerService;
        this.conversationDAO = conversationDAO;
    }
}

