/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.service.impl;

import com.messenger.marci.Documents.StateConversation;
import com.messenger.marci.Repository.Services.ConversationDAO;
import com.messenger.marci.client.lhiaflow.LhiaFlowRequest;
import com.messenger.marci.client.lhiaflow.service.ApiLhiaFLowService;
import com.messenger.marci.client.tsa.TsaApiService;
import com.messenger.marci.data.tsa.RequestMessageModel;
import com.messenger.marci.messenger.data.messages.extractData.ExtractDataEntry;
import com.messenger.marci.service.StateConversationService;
import com.messenger.marci.utils.MessageTypeUtils;
import com.messenger.marci.utils.StatusUtil;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class StateConversationServiceImpl
implements StateConversationService {
    private static final Logger log = LoggerFactory.getLogger(StateConversationServiceImpl.class);
    private final ApiLhiaFLowService apiLhiaFLowService;
    private final TsaApiService thinkAgentApiService;
    private final ConversationDAO conversationDAO;
    private final Environment env;

    public Mono<String> validateConversationAndGetStatusConversation(ExtractDataEntry dataEntry) {
        String defaultCallback = this.env.getProperty("tsa.canal.callback.atencion");
        String conversationId = dataEntry.getMessaging().getSenderId();
        return this.getStatusCoonversation(conversationId).defaultIfEmpty((Object)StatusUtil.ST_NORMAL).flatMap(status -> {
            String statusIdentified = this.validateMessageIfUserRequestAnEventStatus(dataEntry.getMessaging().getMessage());
            return this.getCallbackIdFromConversationId(conversationId).defaultIfEmpty((Object)defaultCallback).flatMap(callbackId -> {
                log.info("callbackId: {}, modo {}, usuario {}", new Object[]{callbackId, statusIdentified, conversationId});
                return this.updateConversation(conversationId, statusIdentified == null ? status : statusIdentified, callbackId).flatMap(conversation -> Mono.just((Object)conversation.getStateConversation()));
            });
        });
    }

    private String validateMessageIfUserRequestAnEventStatus(String message) {
        log.info("Validando si requiere cambio de estado con el mensaje: {}", (Object)message);
        if (message != null) {
            String messageCleaned = message.replaceAll(" ", "").toUpperCase();
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_LHIA)) {
                log.info("El usuario solicita hablar con lhia");
                return StatusUtil.ST_LHIA;
            }
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_FINALIZAR)) {
                log.info("El usuario solicita finalizar la conversaci\u00f3n");
                return StatusUtil.ST_FINALIZAR;
            }
            if (messageCleaned.equalsIgnoreCase(StatusUtil.ST_CAMPANA)) {
                log.info("El usuario solicita hablar con campa\u00f1a");
                return StatusUtil.ST_CAMPANA;
            }
        }
        log.info("El mensaje no solicita un cambio de estado");
        return null;
    }

    public Mono<String> getStatusCoonversation(String conversationId) {
        return this.conversationDAO.getStatusConversationByConversationId(conversationId);
    }

    public Mono<String> getCallbackIdFromConversationId(String conversationId) {
        log.info("Obteniendo callbackId de la conversaci\u00f3n: {}", (Object)conversationId);
        return this.conversationDAO.getCallbackByConversationId(conversationId);
    }

    public Mono<StateConversation> updateConversation(String conversationId, String stateConversation, String callback) {
        return this.conversationDAO.existsByConversationId(conversationId).flatMap(exists -> {
            if (exists.booleanValue()) {
                log.warn("La conversacion existe, actualizando conversaci\u00f3n: {}, callback {}", (Object)conversationId, (Object)callback);
                return this.conversationDAO.findByConversationId(conversationId).flatMap(conversation -> {
                    conversation.setActive(Boolean.valueOf(true));
                    conversation.setStateConversation(stateConversation);
                    conversation.setUpdatedAt(LocalDateTime.now());
                    if (callback != null) {
                        conversation.setCallbackId(callback);
                    }
                    return this.conversationDAO.save(conversation);
                });
            }
            log.warn("La conversacion no existe, creando conversaci\u00f3n: {}", (Object)conversationId);
            StateConversation newConversation = new StateConversation(conversationId, stateConversation, callback);
            return this.conversationDAO.save(newConversation);
        });
    }

    public Mono<Void> updateStateByConversationId(String conversationId, String state) {
        return this.getStatusCoonversation(conversationId).flatMap(status -> this.getCallbackIdFromConversationId(conversationId).flatMap(callbackId -> this.validateAndUpdateChat(conversationId, state, callbackId).then()));
    }

    public Mono<Void> validateAndUpdateChat(String conversationId, String stateConversation, String callback) {
        System.out.println("cerrando");
        return this.conversationDAO.existsByConversationId(conversationId).flatMap(exists -> {
            log.warn("estado: {}", exists);
            if (exists.booleanValue()) {
                return this.conversationDAO.findByConversationId(conversationId).flatMap(conversation -> {
                    conversation.setActive(Boolean.valueOf(true));
                    conversation.setStateConversation(stateConversation);
                    conversation.setUpdatedAt(LocalDateTime.now());
                    if (callback != null) {
                        conversation.setCallbackId(callback);
                    }
                    return this.conversationDAO.save(conversation).then();
                });
            }
            StateConversation newConversation = callback == null ? new StateConversation(conversationId, stateConversation) : new StateConversation(conversationId, stateConversation, callback);
            return this.conversationDAO.save(newConversation).then();
        });
    }

    public Mono<Void> updateStateConversation(String conversationId, String event, String callback, String nick, String initialMessage) {
        log.info("Actualizando conversaci\u00f3n: {}, estado: {}, callback: {}", new Object[]{conversationId, event, callback});
        event = event.toUpperCase().trim().replace(" ", "");
        initialMessage = initialMessage == null || initialMessage.isBlank() ? "Hola" : initialMessage;
        RequestMessageModel messageModelTSA = RequestMessageModel.startConversationFromUpdatedStatus((String)conversationId, (String)MessageTypeUtils.TYPE_MESSAGE, (String)nick, (String)MessageTypeUtils.TYPE_TEXT, (String)initialMessage);
        switch (event) {
            case "BOT": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, callback);
            }
            case "NORMAL": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_NORMAL, callback);
            }
            case "THINKAGENT": 
            case "ASESOR": {
                if (callback != null && callback.startsWith(this.env.getProperty("tsa.canal.prefix"))) {
                    return this.validateAndUpdateChat(conversationId, StatusUtil.ST_THINKAGENT, callback).then(this.thinkAgentApiService.sendMesssageToAsesor(messageModelTSA, callback).then());
                }
                LhiaFlowRequest req = new LhiaFlowRequest();
                req.setChannel("whatsapp");
                req.setMessage("Hola");
                req.setCallbackId(callback);
                req.setConversationChatId(conversationId);
                req.setType("text");
                req.setNick(nick);
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_ASESOR, callback).then(this.apiLhiaFLowService.sendMesssageToAsesor(req).then());
            }
            case "LHIA": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_LHIA, callback);
            }
            case "CAMPANA": {
                return this.validateAndUpdateChat(conversationId, StatusUtil.ST_CAMPANA, callback);
            }
        }
        return this.validateAndUpdateChat(conversationId, StatusUtil.ST_LHIA, callback);
    }

    public ApiLhiaFLowService getApiLhiaFLowService() {
        return this.apiLhiaFLowService;
    }

    public TsaApiService getThinkAgentApiService() {
        return this.thinkAgentApiService;
    }

    public ConversationDAO getConversationDAO() {
        return this.conversationDAO;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateConversationServiceImpl)) {
            return false;
        }
        StateConversationServiceImpl other = (StateConversationServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ApiLhiaFLowService this$apiLhiaFLowService = this.getApiLhiaFLowService();
        ApiLhiaFLowService other$apiLhiaFLowService = other.getApiLhiaFLowService();
        if (this$apiLhiaFLowService == null ? other$apiLhiaFLowService != null : !this$apiLhiaFLowService.equals(other$apiLhiaFLowService)) {
            return false;
        }
        TsaApiService this$thinkAgentApiService = this.getThinkAgentApiService();
        TsaApiService other$thinkAgentApiService = other.getThinkAgentApiService();
        if (this$thinkAgentApiService == null ? other$thinkAgentApiService != null : !this$thinkAgentApiService.equals(other$thinkAgentApiService)) {
            return false;
        }
        ConversationDAO this$conversationDAO = this.getConversationDAO();
        ConversationDAO other$conversationDAO = other.getConversationDAO();
        if (this$conversationDAO == null ? other$conversationDAO != null : !this$conversationDAO.equals(other$conversationDAO)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateConversationServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiLhiaFLowService $apiLhiaFLowService = this.getApiLhiaFLowService();
        result = result * 59 + ($apiLhiaFLowService == null ? 43 : $apiLhiaFLowService.hashCode());
        TsaApiService $thinkAgentApiService = this.getThinkAgentApiService();
        result = result * 59 + ($thinkAgentApiService == null ? 43 : $thinkAgentApiService.hashCode());
        ConversationDAO $conversationDAO = this.getConversationDAO();
        result = result * 59 + ($conversationDAO == null ? 43 : $conversationDAO.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "StateConversationServiceImpl(apiLhiaFLowService=" + String.valueOf(this.getApiLhiaFLowService()) + ", thinkAgentApiService=" + String.valueOf(this.getThinkAgentApiService()) + ", conversationDAO=" + String.valueOf(this.getConversationDAO()) + ", env=" + String.valueOf(this.getEnv()) + ")";
    }

    public StateConversationServiceImpl(ApiLhiaFLowService apiLhiaFLowService, TsaApiService thinkAgentApiService, ConversationDAO conversationDAO, Environment env) {
        this.apiLhiaFLowService = apiLhiaFLowService;
        this.thinkAgentApiService = thinkAgentApiService;
        this.conversationDAO = conversationDAO;
        this.env = env;
    }
}

