/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.messenger.marci.Documents.HistoryConversationItem;
import com.messenger.marci.client.lhia.service.ApiLhiaService;
import com.messenger.marci.data.conversation.TextMessageRequest;
import com.messenger.marci.data.tsa.RequestMessageModel;
import com.messenger.marci.messenger.data.lhia.RequestQuestionLhia;
import com.messenger.marci.messenger.data.lhia.ResponseLhia;
import com.messenger.marci.messenger.data.messages.attachments.buttons.ButtonMessenger;
import com.messenger.marci.messenger.data.messages.extractData.ExtractDataEntry;
import com.messenger.marci.messenger.service.MessagesMessengerService;
import com.messenger.marci.service.ButtonBuilderMetaService;
import com.messenger.marci.service.HistoryConversationItemService;
import com.messenger.marci.service.HistoryConversationService;
import com.messenger.marci.service.LhiaProcessService;
import com.messenger.marci.service.ThinkAgentService;
import com.messenger.marci.utils.BuildLhiaMessageUtils;
import com.messenger.marci.utils.EventLhiaEnum;
import com.messenger.marci.utils.MessageTypeUtils;
import com.messenger.marci.utils.PlatformEnum;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class LhiaProcessServiceImpl
implements LhiaProcessService {
    private static final Logger log = LoggerFactory.getLogger(LhiaProcessServiceImpl.class);
    private final Environment env;
    private final ApiLhiaService apiLhiaService;
    private final HistoryConversationItemService historyConversationService;
    private final MessagesMessengerService messagesMessengerService;
    private final ButtonBuilderMetaService builderMetaService;
    private final ObjectMapper objectMapper;
    private final HistoryConversationService historyConverService;
    private final ThinkAgentService thinkAgentService;

    private RequestQuestionLhia buildRequestQuestionLhia(ExtractDataEntry data) {
        log.info("building request to lhia with type {}", (Object)data.getMessageType());
        String descripcion = this.env.getProperty("lhia.api.role");
        String usuario = this.env.getProperty("lhia.api.user");
        RequestQuestionLhia requestToLhia = new RequestQuestionLhia();
        String messageToLhia = data.getMessaging().getMessage();
        if (data.getMessageType().equals(MessageTypeUtils.POSTBACK_MESSAGE)) {
            requestToLhia.setActivity(messageToLhia);
        }
        requestToLhia.setQuestion(messageToLhia);
        requestToLhia.setDescripcion(descripcion);
        requestToLhia.setUsuario(usuario);
        requestToLhia.setIdPlatform(data.getMessaging().getSenderId());
        requestToLhia.setPlatform(PlatformEnum.MESSENGER.getPlatform());
        return requestToLhia;
    }

    public Mono<Void> sendMessageLhiaSwitch(ExtractDataEntry data) {
        RequestQuestionLhia requestToLhia = this.buildRequestQuestionLhia(data);
        log.info("request lhia event {}", (Object)requestToLhia);
        if (requestToLhia.getActivity() == null) {
            return this.sendMessageToLHIA(requestToLhia, data).then();
        }
        return this.sendMessageToLHIAEvents(requestToLhia, data).then();
    }

    private Mono<?> sendMessageToLHIAEvents(RequestQuestionLhia requestToLhia, ExtractDataEntry data) {
        log.info("LOADING EVENT TO LHIA WITH INFO: {}", (Object)requestToLhia);
        String platformUserId = data.getMessaging().getSenderId();
        return this.apiLhiaService.getToken().flatMap(tokenModel -> this.apiLhiaService.sendEventToLhia(requestToLhia, tokenModel.getAccessToken()).flatMap(responseLhia -> {
            log.info("responseLhia service {}", responseLhia);
            if (responseLhia.getSuccess().booleanValue() && responseLhia.getPayload() != null) {
                String lhiaEventMessage = responseLhia.getPayload().getMessage();
                TextMessageRequest templateInitMessage = new TextMessageRequest();
                templateInitMessage.setPhoneNumber(requestToLhia.getIdPlatform());
                templateInitMessage.setMessage(lhiaEventMessage);
                if (responseLhia.getPayload().getHasEvent().booleanValue()) {
                    List events = responseLhia.getPayload().getEvents();
                    String eventTitle = responseLhia.getPayload().getTitleEvent();
                    List buttons = this.builderMetaService.generateListButtonFromEvent(events);
                    if (buttons != null && !buttons.isEmpty()) {
                        return this.messagesMessengerService.sendTextMessage(platformUserId, lhiaEventMessage).flatMap(textMessageResponse -> this.processMessageAndSave(textMessageResponse, requestToLhia, lhiaEventMessage, data).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)).then(this.messagesMessengerService.sendGenericTemplateMessageButtons(platformUserId, eventTitle, buttons)).flatMap(responseMeta -> {
                            String concatenatedEvents = "Eventos: " + buttons.stream().map(ButtonMessenger::getTitle).collect(Collectors.joining(", "));
                            return this.processMessageAndSave(responseMeta, requestToLhia, concatenatedEvents, data);
                        }));
                    }
                }
                return this.messagesMessengerService.sendTextMessage(platformUserId, lhiaEventMessage).flatMap(textMessageResponse -> this.processMessageAndSave(textMessageResponse, requestToLhia, lhiaEventMessage, data).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)));
            }
            String lhiaEventMessage = responseLhia.getPayload().getMessage();
            return this.messagesMessengerService.sendTextMessage(platformUserId, lhiaEventMessage).flatMap(textMessageResponse -> this.processMessageAndSave(textMessageResponse, requestToLhia, lhiaEventMessage, data).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)));
        })).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
    }

    private Mono<ResponseLhia> sendMessageToLHIA(RequestQuestionLhia requestToLhia, ExtractDataEntry data) {
        String platformUserId = data.getMessaging().getSenderId();
        return this.apiLhiaService.getToken().flatMap(tokenModel -> this.apiLhiaService.sendMesssageToLhia(requestToLhia, tokenModel.getAccessToken()).flatMap(responseLhia -> {
            log.info("responseLhia service {}", responseLhia);
            if (responseLhia.getResponse() != null && responseLhia.getResponse().equalsIgnoreCase(EventLhiaEnum.REDIRECT_ASESOR.getKey())) {
                log.info("redirecting to asesor");
                return this.historyConverService.getNameFromConversation(platformUserId).flatMap(nickname -> {
                    RequestMessageModel requestMessageModel = RequestMessageModel.responseConversationFromLHIA((String)platformUserId, (String)MessageTypeUtils.TYPE_MESSAGE, (String)nickname, (String)MessageTypeUtils.TYPE_TEXT, (String)"Hola, este usuario fue dirigido a ti por Marci y ahora requiere asistencia personalizada.");
                    return this.thinkAgentService.redirectLhiaConversationToTSA(requestMessageModel).thenReturn(responseLhia);
                });
            }
            if (responseLhia.getListProductVectorial() != null && !responseLhia.getListProductVectorial().isEmpty()) {
                return Mono.when((Iterable)responseLhia.getListProductVectorial().stream().map(productVectorial -> {
                    if (responseLhia.getListProductVectorial().size() > 1) {
                        String messaje = this.getMessageBuildFromProductLhia(productVectorial);
                        List elements = BuildLhiaMessageUtils.buildCardProduct((ResponseLhia.LhiaProduct)productVectorial);
                        return this.messagesMessengerService.sendGenericTemplateMessage(platformUserId, elements).flatMap(responseMeta -> this.processMessageAndSave(responseMeta, requestToLhia, messaje, data));
                    }
                    if (responseLhia.getListProductVectorial().size() == 1) {
                        String messaje = "Event:" + responseLhia.getResponse() + "\n".concat("Producto: " + this.getMessageBuildFromProductLhia(productVectorial));
                        String event = responseLhia.getResponse();
                        List elements = BuildLhiaMessageUtils.buildCardProductEvent((ResponseLhia.LhiaProduct)productVectorial, (String)event);
                        return this.messagesMessengerService.sendGenericTemplateMessage(platformUserId, elements).flatMap(responseMeta -> this.processMessageAndSave(responseMeta, requestToLhia, messaje, data));
                    }
                    return Mono.empty();
                }).collect(Collectors.toList())).then(this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia));
            }
            if (responseLhia.getResponse() != null) {
                responseLhia.setResponse(responseLhia.getResponse());
            }
            return this.messagesMessengerService.sendTextMessage(platformUserId, responseLhia.getResponse()).flatMap(responseMeta -> this.processMessageAndSave(responseMeta, requestToLhia, responseLhia.getResponse(), data)).flatMap(ignore -> this.apiLhiaService.getSignOut(tokenModel.getRefreshToken()).thenReturn(responseLhia)).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
        })).onErrorResume(e -> this.handleError(e, "Error in sendMessageToLHIA"));
    }

    private String getMessageBuildFromProductLhia(ResponseLhia.LhiaProduct product) {
        return "Producto Encontrado: " + product.getTitulo() + "\nPrecio: " + product.getPrecio() + "\n";
    }

    private Mono<ResponseEntity<String>> processMessageAndSave(ResponseEntity<String> responseMeta, RequestQuestionLhia requestToLhia, String message, ExtractDataEntry data) {
        log.info("responseMeta {}", responseMeta.getBody());
        if (responseMeta.getStatusCode().is2xxSuccessful()) {
            String messageId = (String)responseMeta.getBody();
            return this.saveHistoryConversationsLhia(requestToLhia, messageId, message, data).thenReturn(responseMeta);
        }
        return this.saveHistoryConversationsLhia(requestToLhia, UUID.randomUUID().toString(), message, data).thenReturn(responseMeta);
    }

    private Mono<String> getMessageIdFromResponseMeta(String responseJson) {
        return Mono.fromCallable(() -> {
            try {
                log.info("Parsing response message: {}", (Object)responseJson);
                JsonNode jsonNode = this.objectMapper.readTree(responseJson);
                return jsonNode.has("message_id") ? jsonNode.get("message_id").asText() : UUID.randomUUID().toString();
            }
            catch (Exception e) {
                log.error("Error parsing JSON response: {}", (Object)e.getMessage());
                return UUID.randomUUID().toString();
            }
        }).onErrorReturn((Object)UUID.randomUUID().toString());
    }

    private Mono<Void> saveHistoryConversationsLhia(RequestQuestionLhia requestToLhia, String messageId, String message, ExtractDataEntry data) {
        String metaMessageId = messageId == null ? UUID.randomUUID().toString() : messageId;
        HistoryConversationItem lhiaHistoryConversationItem = new HistoryConversationItem(requestToLhia.getIdPlatform(), requestToLhia.getPlatform(), metaMessageId, message, "LHIA", "LHIA");
        log.info("saving history conversation item {}", (Object)lhiaHistoryConversationItem);
        return this.historyConversationService.save(lhiaHistoryConversationItem);
    }

    private <T> Mono<T> handleError(Throwable e, String errorMessage) {
        log.error(errorMessage, e);
        return Mono.error((Throwable)new RuntimeException(errorMessage, e));
    }

    public LhiaProcessServiceImpl(Environment env, ApiLhiaService apiLhiaService, HistoryConversationItemService historyConversationService, MessagesMessengerService messagesMessengerService, ButtonBuilderMetaService builderMetaService, ObjectMapper objectMapper, HistoryConversationService historyConverService, ThinkAgentService thinkAgentService) {
        this.env = env;
        this.apiLhiaService = apiLhiaService;
        this.historyConversationService = historyConversationService;
        this.messagesMessengerService = messagesMessengerService;
        this.builderMetaService = builderMetaService;
        this.objectMapper = objectMapper;
        this.historyConverService = historyConverService;
        this.thinkAgentService = thinkAgentService;
    }
}

