/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.service.impl;

import com.messenger.marci.Documents.HistoryConversation;
import com.messenger.marci.Documents.HistoryConversationItem;
import com.messenger.marci.Repository.HistoryConversationItemRepository;
import com.messenger.marci.client.lhiaflow.LhiaFlowRequest;
import com.messenger.marci.client.messenger.data.FacebookUserInfo;
import com.messenger.marci.client.messenger.service.ApiMessengerService;
import com.messenger.marci.data.conversation.PagedResponse;
import com.messenger.marci.helpers.HistoryConversationItemHelper;
import com.messenger.marci.messenger.data.messages.extractData.ExtractDataEntry;
import com.messenger.marci.service.HistoryConversationItemService;
import com.messenger.marci.service.HistoryConversationService;
import com.messenger.marci.utils.MessageTypeUtils;
import com.messenger.marci.utils.PlatformEnum;
import com.messenger.marci.utils.StatusUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class HistoryConversationItemServiceImpl
implements HistoryConversationItemService {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationItemServiceImpl.class);
    private final HistoryConversationItemRepository historyConversationItemRepository;
    private final HistoryConversationService historyConversationService;
    private final HistoryConversationItemHelper historyConversationItemHelper;
    private final ApiMessengerService apiMessengerService;

    public Mono<String> getMessageByMetaId(String metaId) {
        return this.historyConversationItemRepository.findByMessageMetaId(metaId).map(HistoryConversationItem::getMessage).switchIfEmpty(Mono.just((Object)"No se encontr\u00f3 el mensaje respondido"));
    }

    public Mono<String> getNameFromApiMeta(String conversationId) {
        return this.apiMessengerService.getFacebookUserInfo(conversationId, "name").flatMap(response -> Mono.just((Object)((FacebookUserInfo)response.getBody()).getName()));
    }

    public Mono<Void> saveConversationFromWebhookMessenger(ExtractDataEntry dataEntry, String statusConversation) {
        return this.getNameFromApiMeta(dataEntry.getMessaging().getSenderId()).flatMap(name -> this.extractMessageFromDataEntry(dataEntry).flatMap(message -> {
            HistoryConversationItem historyConversationItem = new HistoryConversationItem(dataEntry.getMessaging().getSenderId(), PlatformEnum.MESSENGER.getPlatform(), dataEntry.getMessaging().getMessageId(), message, StatusUtil.ROL_USER, statusConversation, name);
            return this.save(historyConversationItem);
        }));
    }

    public Mono<String> extractMessageFromDataEntry(ExtractDataEntry dataEntry) {
        String messageType = dataEntry.getMessageType();
        if (messageType.equals(MessageTypeUtils.REPLY_MESSAGE)) {
            return this.getMessageByMessageMetaId(dataEntry.getMessaging().getReplyTo()).defaultIfEmpty((Object)"NO ENCONTRADO").flatMap(message -> {
                String fullMessage = "Mensaje de respuesta: " + message + "\nMensaje original: " + dataEntry.getMessaging().getMessage();
                log.info("fullMessage: {}", (Object)fullMessage);
                return Mono.just((Object)fullMessage);
            });
        }
        if (messageType.equals(MessageTypeUtils.TEXT_MESSAGE)) {
            return Mono.just((Object)dataEntry.getMessaging().getMessage());
        }
        return Mono.just((Object)("Archivo de tipo [" + dataEntry.getMessageType() + "]"));
    }

    private Mono<String> getMessageByMessageMetaId(String messageMetaId) {
        return this.historyConversationItemRepository.findByMessageMetaId(messageMetaId).map(HistoryConversationItem::getMessage);
    }

    public Mono<Void> save(HistoryConversationItem historyConversation) {
        log.info("Attempting to save HistoryConversation with conversationId: {}", (Object)historyConversation.getIdPlatform());
        Mono nickMono = historyConversation.getNick() == null ? this.getNameIfNotExists(historyConversation.getIdPlatform()) : Mono.just((Object)historyConversation.getNick());
        return nickMono.flatMap(nick -> {
            historyConversation.setNick(nick);
            return this.historyConversationItemRepository.save((Object)historyConversation).doOnSuccess(response -> log.info("UserResponse saved: {}", response)).then(this.historyConversationService.save(new HistoryConversation(historyConversation.getIdPlatform(), historyConversation.getNick(), historyConversation.getPlatform()))).onErrorResume(error -> {
                log.error("Error saving UserResponse: {}", (Object)error.getMessage());
                return Mono.empty();
            });
        });
    }

    private Mono<String> getNameIfNotExists(String conversationId) {
        return this.historyConversationService.getNameFromConversation(conversationId).switchIfEmpty(this.getNameFromApiMeta(conversationId));
    }

    public Mono<PagedResponse<HistoryConversationItem>> getHistoryConversationItems(int page, int size, String sortDirection, String idPlatform) {
        Sort sort = "desc".equalsIgnoreCase(sortDirection) ? Sort.by((String[])new String[]{"createdAt"}).descending() : Sort.by((String[])new String[]{"createdAt"}).ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        return this.historyConversationItemRepository.countByIdPlatform(idPlatform).flatMap(arg_0 -> this.lambda$getHistoryConversationItems$8(size, page, idPlatform, (Pageable)pageable, arg_0));
    }

    public Flux<Map<String, Object>> getMessagesCountByDay(String startDateParam, String endDateParam) {
        return this.historyConversationItemHelper.getMessagesCountByDay(startDateParam, endDateParam);
    }

    public Mono<Map<String, Object>> getReportInformationConversations(String startDateParam, String endDateParam) {
        Mono usersSessionCountMono = this.historyConversationItemHelper.getUsersCountByDay(startDateParam, endDateParam);
        Mono messagesCountBot = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("BOT", "LHIA"));
        Mono messagesCountAssessor = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("ASESOR"));
        Mono messagesCountUser = this.historyConversationItemHelper.getMessagesCountByRoleAndDateRange(startDateParam, endDateParam, List.of("USER"));
        return Mono.zip((Mono)usersSessionCountMono, (Mono)messagesCountBot, (Mono)messagesCountAssessor, (Mono)messagesCountUser).map(tuple -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("userSession", tuple.getT1());
            result.put("messagesBot", tuple.getT2());
            result.put("messagesAssessor", tuple.getT3());
            result.put("messagesUser", tuple.getT4());
            return result;
        });
    }

    public Mono<Void> saveHistoryConversations(LhiaFlowRequest messageModel, String rol) {
        System.out.println(messageModel);
        HistoryConversationItem userHistoryConversation = new HistoryConversationItem(messageModel.getConversationChatId(), messageModel.getChannel(), "messageModel.getMessageId()", (String)(messageModel.getMessage() != null ? messageModel.getMessage() : "Archivo de tipo [" + messageModel.getType() + "]"), rol.toUpperCase(), "CAMPANA", messageModel.getNick());
        return this.save(userHistoryConversation).then();
    }

    public HistoryConversationItemServiceImpl(HistoryConversationItemRepository historyConversationItemRepository, HistoryConversationService historyConversationService, HistoryConversationItemHelper historyConversationItemHelper, ApiMessengerService apiMessengerService) {
        this.historyConversationItemRepository = historyConversationItemRepository;
        this.historyConversationService = historyConversationService;
        this.historyConversationItemHelper = historyConversationItemHelper;
        this.apiMessengerService = apiMessengerService;
    }

    private /* synthetic */ Mono lambda$getHistoryConversationItems$8(int size, int page, String idPlatform, Pageable pageable, Long totalElements) {
        int totalPages = (int)Math.ceil((double)totalElements.longValue() / (double)size);
        boolean isLast = page + 1 >= totalPages;
        return this.historyConversationItemRepository.findAllByIdPlatform(idPlatform, pageable).collectList().map(content -> new PagedResponse(content, page, size, totalElements.longValue(), totalPages, isLast));
    }
}

