/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.messenger.service.impl;

import com.messenger.marci.client.messenger.data.MetaResponseMessage;
import com.messenger.marci.client.messenger.service.ApiMessengerService;
import com.messenger.marci.messenger.data.messages.ElementMessenger;
import com.messenger.marci.messenger.data.messages.GenericTemplateMessengerMessage;
import com.messenger.marci.messenger.data.messages.TextMessengerMessage;
import com.messenger.marci.messenger.data.messages.attachments.buttons.ButtonMessenger;
import com.messenger.marci.messenger.service.MessagesMessengerService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class MessagesMessengerServiceImpl
implements MessagesMessengerService {
    private static final Logger log = LoggerFactory.getLogger(MessagesMessengerServiceImpl.class);
    private final ApiMessengerService apiMessengerService;

    public Mono<ResponseEntity<String>> sendTextMessage(String recipientId, String text) {
        log.info("Sending text message to recipientId: {}, text: {}", (Object)recipientId, (Object)text);
        TextMessengerMessage message = new TextMessengerMessage(recipientId, text);
        return this.apiMessengerService.sendMessengerMessage((Object)message).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)((MetaResponseMessage)response.getBody()).getMessageId())));
    }

    public Mono<ResponseEntity<String>> sendIndividualFileMessage(String platformIdUser, String type, String url) {
        GenericTemplateMessengerMessage message = new GenericTemplateMessengerMessage(platformIdUser, type, url);
        return this.apiMessengerService.sendMessengerMessage((Object)message).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)((MetaResponseMessage)response.getBody()).getMessageId())));
    }

    public Mono<ResponseEntity<String>> sendGenericTemplateMessage(String platformIdUser, List<ElementMessenger> elements) {
        GenericTemplateMessengerMessage message = new GenericTemplateMessengerMessage(platformIdUser, elements);
        return this.apiMessengerService.sendMessengerMessage((Object)message).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)((MetaResponseMessage)response.getBody()).getMessageId())));
    }

    public Mono<ResponseEntity<String>> sendGenericTemplateMessageButtons(String platformIdUser, String eventTittle, List<ButtonMessenger> elements) {
        GenericTemplateMessengerMessage message = new GenericTemplateMessengerMessage(platformIdUser, eventTittle, elements);
        return this.apiMessengerService.sendMessengerMessage((Object)message).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)((MetaResponseMessage)response.getBody()).getMessageId())));
    }

    public MessagesMessengerServiceImpl(ApiMessengerService apiMessengerService) {
        this.apiMessengerService = apiMessengerService;
    }
}

