/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.messenger.marci.config.ApiResponse;
import java.io.IOException;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class CustomAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException authException) {
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        String mensaje = "No autorizado.";
        if (authException.getMessage().toUpperCase().contains("JWT EXPIRED")) {
            mensaje = "Token caducado";
        }
        ApiResponse apiResponse = ApiResponse.error((int)HttpStatus.UNAUTHORIZED.value(), (String)mensaje);
        return exchange.getResponse().writeWith((Publisher)Mono.fromSupplier(() -> {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes((Object)apiResponse);
                return exchange.getResponse().bufferFactory().wrap(bytes);
            }
            catch (IOException e) {
                return exchange.getResponse().bufferFactory().wrap(new byte[0]);
            }
        }));
    }
}

