/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.messenger.marci.config.ApiResponse;
import java.io.IOException;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class CustomAccessDeniedHandler
implements ServerAccessDeniedHandler {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Mono<Void> handle(ServerWebExchange exchange, AccessDeniedException denied) {
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN);
        exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        ApiResponse apiResponse = ApiResponse.error((int)HttpStatus.FORBIDDEN.value(), (String)"Acceso denegado");
        return exchange.getResponse().writeWith((Publisher)Mono.fromSupplier(() -> {
            try {
                byte[] bytes = this.objectMapper.writeValueAsBytes((Object)apiResponse);
                return exchange.getResponse().bufferFactory().wrap(bytes);
            }
            catch (IOException e) {
                return exchange.getResponse().bufferFactory().wrap(new byte[0]);
            }
        }));
    }
}

