/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.messenger.marci.client.messenger.service.ApiMessengerService;
import com.messenger.marci.service.WebhookService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"webhook"})
public class MetaWebhook {
    private static final Logger log = LoggerFactory.getLogger(MetaWebhook.class);
    private final WebhookService webhookService;
    private final ApiMessengerService apiMessengerService;
    private final Environment env;

    @GetMapping(value={""})
    public Mono<ResponseEntity<String>> verifyWebhook(@RequestParam(name="hub.verify_token", required=false) String verifyToken, @RequestParam(name="hub.challenge", required=false) String challenge) {
        log.info("Verificando webhook con token y challenge");
        String VERIFY_TOKEN = this.env.getProperty("messenger.api.verify-token");
        if (VERIFY_TOKEN.equals(verifyToken)) {
            return Mono.just((Object)new ResponseEntity((Object)challenge, (HttpStatusCode)HttpStatus.OK));
        }
        log.error("Error de verificaci\u00f3n: token no coincide");
        return Mono.just((Object)new ResponseEntity((Object)"Error de verificaci\u00f3n", (HttpStatusCode)HttpStatus.FORBIDDEN));
    }

    @PostMapping(value={""})
    public Mono<ResponseEntity<?>> webhook(@RequestBody JsonNode body) {
        log.info("Nuevo callback recibido");
        return this.webhookService.identificarWebhook(body);
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public ApiMessengerService getApiMessengerService() {
        return this.apiMessengerService;
    }

    public Environment getEnv() {
        return this.env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaWebhook)) {
            return false;
        }
        MetaWebhook other = (MetaWebhook)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebhookService this$webhookService = this.getWebhookService();
        WebhookService other$webhookService = other.getWebhookService();
        if (this$webhookService == null ? other$webhookService != null : !this$webhookService.equals(other$webhookService)) {
            return false;
        }
        ApiMessengerService this$apiMessengerService = this.getApiMessengerService();
        ApiMessengerService other$apiMessengerService = other.getApiMessengerService();
        if (this$apiMessengerService == null ? other$apiMessengerService != null : !this$apiMessengerService.equals(other$apiMessengerService)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaWebhook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebhookService $webhookService = this.getWebhookService();
        result = result * 59 + ($webhookService == null ? 43 : $webhookService.hashCode());
        ApiMessengerService $apiMessengerService = this.getApiMessengerService();
        result = result * 59 + ($apiMessengerService == null ? 43 : $apiMessengerService.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "MetaWebhook(webhookService=" + String.valueOf(this.getWebhookService()) + ", apiMessengerService=" + String.valueOf(this.getApiMessengerService()) + ", env=" + String.valueOf(this.getEnv()) + ")";
    }

    public MetaWebhook(WebhookService webhookService, ApiMessengerService apiMessengerService, Environment env) {
        this.webhookService = webhookService;
        this.apiMessengerService = apiMessengerService;
        this.env = env;
    }
}

