/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.controller;

import com.messenger.marci.Documents.HistoryConversation;
import com.messenger.marci.Documents.HistoryConversationItem;
import com.messenger.marci.data.conversation.PagedResponse;
import com.messenger.marci.service.HistoryConversationItemService;
import com.messenger.marci.service.HistoryConversationService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/history-conversation"})
public class HistoryConversationController {
    private static final Logger log = LoggerFactory.getLogger(HistoryConversationController.class);
    private final HistoryConversationService historyConversationService;
    private final HistoryConversationItemService historyConversationItemService;

    @PostMapping(value={"/conversation"})
    public Mono<ResponseEntity<PagedResponse<HistoryConversation>>> getHistoryConversations(ServerWebExchange exchange) {
        return exchange.getFormData().flatMap(formData -> {
            String filterParam = (String)formData.getFirst((Object)"filterValue");
            String pageParam = (String)formData.getFirst((Object)"page");
            String sizeParam = (String)formData.getFirst((Object)"size");
            String sortDirectionParam = (String)formData.getFirst((Object)"sortDirection");
            int page = pageParam != null ? Integer.parseInt(pageParam) : 0;
            int size = sizeParam != null ? Integer.parseInt(sizeParam) : 10;
            String sortDirection = sortDirectionParam != null ? sortDirectionParam : "desc";
            return this.historyConversationService.getHistoryConversations(page, size, sortDirection, filterParam).map(pagedResponse -> new ResponseEntity(pagedResponse, (HttpStatusCode)HttpStatus.OK)).defaultIfEmpty((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT));
        });
    }

    @PostMapping(value={"/conversation-item"})
    public Mono<ResponseEntity<PagedResponse<HistoryConversationItem>>> getHistoryConversationItems(ServerWebExchange exchange) {
        return exchange.getFormData().flatMap(formData -> {
            String pageParam = (String)formData.getFirst((Object)"page");
            String sizeParam = (String)formData.getFirst((Object)"size");
            String sortDirectionParam = (String)formData.getFirst((Object)"sortDirection");
            String idPlatformParam = (String)formData.getFirst((Object)"idPlatform");
            int page = pageParam != null ? Integer.parseInt(pageParam) : 0;
            int size = sizeParam != null ? Integer.parseInt(sizeParam) : 10;
            String sortDirection = sortDirectionParam != null ? sortDirectionParam : "desc";
            String idPlatform = idPlatformParam != null ? idPlatformParam : "";
            return this.historyConversationItemService.getHistoryConversationItems(page, size, sortDirection, idPlatform).map(pagedResponse -> new ResponseEntity(pagedResponse, (HttpStatusCode)HttpStatus.OK)).defaultIfEmpty((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT));
        });
    }

    @PostMapping(value={"/messages-for-day"})
    public Flux<Map<String, Object>> getMessagesCountByDay(ServerWebExchange exchange) {
        return exchange.getFormData().flatMapMany(formData -> {
            String startDateParam = (String)formData.getFirst((Object)"startDate");
            String endDateParam = (String)formData.getFirst((Object)"endDate");
            return this.historyConversationItemService.getMessagesCountByDay(startDateParam, endDateParam);
        });
    }

    @PostMapping(value={"/report-information"})
    public Mono<Map<String, Object>> getMessagesCountByDay2(ServerWebExchange exchange) {
        return exchange.getFormData().flatMap(formData -> {
            String startDateParam = (String)formData.getFirst((Object)"startDate");
            String endDateParam = (String)formData.getFirst((Object)"endDate");
            return this.historyConversationItemService.getReportInformationConversations(startDateParam, endDateParam);
        });
    }

    public HistoryConversationService getHistoryConversationService() {
        return this.historyConversationService;
    }

    public HistoryConversationItemService getHistoryConversationItemService() {
        return this.historyConversationItemService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryConversationController)) {
            return false;
        }
        HistoryConversationController other = (HistoryConversationController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        HistoryConversationService this$historyConversationService = this.getHistoryConversationService();
        HistoryConversationService other$historyConversationService = other.getHistoryConversationService();
        if (this$historyConversationService == null ? other$historyConversationService != null : !this$historyConversationService.equals(other$historyConversationService)) {
            return false;
        }
        HistoryConversationItemService this$historyConversationItemService = this.getHistoryConversationItemService();
        HistoryConversationItemService other$historyConversationItemService = other.getHistoryConversationItemService();
        return !(this$historyConversationItemService == null ? other$historyConversationItemService != null : !this$historyConversationItemService.equals(other$historyConversationItemService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryConversationController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HistoryConversationService $historyConversationService = this.getHistoryConversationService();
        result = result * 59 + ($historyConversationService == null ? 43 : $historyConversationService.hashCode());
        HistoryConversationItemService $historyConversationItemService = this.getHistoryConversationItemService();
        result = result * 59 + ($historyConversationItemService == null ? 43 : $historyConversationItemService.hashCode());
        return result;
    }

    public String toString() {
        return "HistoryConversationController(historyConversationService=" + String.valueOf(this.getHistoryConversationService()) + ", historyConversationItemService=" + String.valueOf(this.getHistoryConversationItemService()) + ")";
    }

    public HistoryConversationController(HistoryConversationService historyConversationService, HistoryConversationItemService historyConversationItemService) {
        this.historyConversationService = historyConversationService;
        this.historyConversationItemService = historyConversationItemService;
    }
}

