/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.controller;

import com.messenger.marci.client.messenger.data.FacebookUserInfo;
import com.messenger.marci.client.messenger.service.ApiMessengerService;
import com.messenger.marci.data.history.HistoryConversationDTO;
import com.messenger.marci.service.HistoryConversationService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/ms"})
public class ApiKeyConversationController {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyConversationController.class);
    private final HistoryConversationService historyConversationService;
    private final ApiMessengerService apiMessengerService;

    @PostMapping(value={"/history-conversation/migrate-conversation"})
    public Mono<ResponseEntity<Void>> saveMigrateConversation(@RequestBody HistoryConversationDTO dataResponse) {
        return this.historyConversationService.saveHistoryMigrate(dataResponse).then(Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK))).onErrorResume(e -> {
            log.error("Error durante la migraci\u00f3n", e);
            return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"/webhook/get-user-name/{userId}"})
    public Mono<Map<String, Object>> getMethodName(@PathVariable String userId) {
        HashMap response = new HashMap();
        return this.apiMessengerService.getFacebookUserInfo(userId, "name").flatMap(user -> {
            FacebookUserInfo body = (FacebookUserInfo)user.getBody();
            response.put("name", body.getName());
            return Mono.just((Object)response);
        });
    }

    public HistoryConversationService getHistoryConversationService() {
        return this.historyConversationService;
    }

    public ApiMessengerService getApiMessengerService() {
        return this.apiMessengerService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiKeyConversationController)) {
            return false;
        }
        ApiKeyConversationController other = (ApiKeyConversationController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        HistoryConversationService this$historyConversationService = this.getHistoryConversationService();
        HistoryConversationService other$historyConversationService = other.getHistoryConversationService();
        if (this$historyConversationService == null ? other$historyConversationService != null : !this$historyConversationService.equals(other$historyConversationService)) {
            return false;
        }
        ApiMessengerService this$apiMessengerService = this.getApiMessengerService();
        ApiMessengerService other$apiMessengerService = other.getApiMessengerService();
        return !(this$apiMessengerService == null ? other$apiMessengerService != null : !this$apiMessengerService.equals(other$apiMessengerService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiKeyConversationController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HistoryConversationService $historyConversationService = this.getHistoryConversationService();
        result = result * 59 + ($historyConversationService == null ? 43 : $historyConversationService.hashCode());
        ApiMessengerService $apiMessengerService = this.getApiMessengerService();
        result = result * 59 + ($apiMessengerService == null ? 43 : $apiMessengerService.hashCode());
        return result;
    }

    public String toString() {
        return "ApiKeyConversationController(historyConversationService=" + String.valueOf(this.getHistoryConversationService()) + ", apiMessengerService=" + String.valueOf(this.getApiMessengerService()) + ")";
    }

    public ApiKeyConversationController(HistoryConversationService historyConversationService, ApiMessengerService apiMessengerService) {
        this.historyConversationService = historyConversationService;
        this.apiMessengerService = apiMessengerService;
    }
}

