/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.client.tsa.service;

import com.messenger.marci.client.tsa.TsaApiService;
import com.messenger.marci.client.utils.WebClientUtils;
import com.messenger.marci.data.tsa.RequestMessageModel;
import com.messenger.marci.utils.PlatformEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class TsaApiServiceImple
implements TsaApiService {
    private static final Logger log = LoggerFactory.getLogger(TsaApiServiceImple.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<String> sendMesssageToAsesor(RequestMessageModel data, String callbackId) {
        data.setCallbackUrl(this.env.getProperty("tsa.api.callback.url"));
        data.setChannel(PlatformEnum.MESSENGER.getPlatform());
        String token = this.env.getProperty("tsa.api.token");
        String headerName = this.env.getProperty("tsa.api.header");
        String API_URL = this.env.getProperty("tsa.api.url.messages").replace("{channel}", callbackId);
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(headerName, token);
        log.info("CONNECTING TO TSA {}", (Object)data);
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue((Object)data), String.class, (String)"Messagen sent tsa").flatMap(res -> Mono.just((Object)((String)res.getBody())));
    }

    public TsaApiServiceImple(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

