/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.client.messenger.service.impl;

import com.messenger.marci.client.messenger.data.FacebookUserInfo;
import com.messenger.marci.client.messenger.data.MetaResponseMessage;
import com.messenger.marci.client.messenger.service.ApiMessengerService;
import com.messenger.marci.client.utils.WebClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiMessengerServiceImpl
implements ApiMessengerService {
    private static final Logger log = LoggerFactory.getLogger(ApiMessengerServiceImpl.class);
    private final Environment env;
    private final WebClient.Builder webClient;

    public Mono<ResponseEntity<MetaResponseMessage>> sendMessengerMessage(Object req) {
        log.info("Sending messenger message {}", req);
        String TOKEN = this.env.getProperty("messenger.api.token");
        String MESSENGER_API_URL = this.env.getProperty("messenger.api.messages");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(TOKEN);
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(MESSENGER_API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(req), MetaResponseMessage.class, (String)"SEND MESSAGE MESSENGER");
    }

    public Mono<ResponseEntity<FacebookUserInfo>> getFacebookUserInfo(String userId, String fields) {
        log.info("Fetching Facebook user info for user ID: {}", (Object)userId);
        String TOKEN = this.env.getProperty("messenger.api.token");
        String FACEBOOK_GRAPH_API_URL = this.env.getProperty("messenger.api.user.info").replace("{{userId}}", userId).replace("{{fields}}", fields);
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(TOKEN);
        return WebClientUtils.handleWebClientResponse((WebClient.RequestHeadersSpec)this.webClient.build().get().uri(FACEBOOK_GRAPH_API_URL, new Object[0]).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers)), FacebookUserInfo.class, (String)"Facebook user info").switchIfEmpty(Mono.just((Object)ResponseEntity.ok((Object)this.getFallbackUserInfo())));
    }

    private FacebookUserInfo getFallbackUserInfo() {
        return new FacebookUserInfo("N/A", "N/A");
    }

    public ApiMessengerServiceImpl(Environment env, WebClient.Builder webClient) {
        this.env = env;
        this.webClient = webClient;
    }
}

