/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.client.lhiaflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.messenger.marci.client.lhiaflow.LhiaFlowRequest;
import com.messenger.marci.client.lhiaflow.service.ApiLhiaFLowService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiLhiaFlow
implements ApiLhiaFLowService {
    private static final Logger log = LoggerFactory.getLogger(ApiLhiaFlow.class);
    private final WebClient.Builder webClient;
    private final Environment env;
    private final ObjectMapper objectMapper;

    public Mono<String> sendMesssageToAsesor(LhiaFlowRequest data) {
        log.info("CONNECTING TO ASSESOR {}", (Object)data);
        String API_URL = this.env.getProperty("lhiaflow.api.sendmessages");
        log.info(API_URL);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map body = new HashMap();
        try {
            body = (Map)this.objectMapper.convertValue((Object)data, Map.class);
        }
        catch (IllegalArgumentException e) {
            return Mono.error((Throwable)new RuntimeException("Error converting WebHookModel to Map", e));
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response webhook {}", response);
            return Mono.just((Object)response);
        });
    }

    public ApiLhiaFlow(WebClient.Builder webClient, Environment env, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.env = env;
        this.objectMapper = objectMapper;
    }
}

