/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.client.lhia;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.messenger.marci.client.lhia.service.ApiLhiaService;
import com.messenger.marci.data.keycloak.TokenKeyCloakModel;
import com.messenger.marci.messenger.data.lhia.RequestQuestionLhia;
import com.messenger.marci.messenger.data.lhia.ResponseLhia;
import com.messenger.marci.messenger.data.lhia.ResponseLhiaEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class ApiLhia
implements ApiLhiaService {
    private static final Logger log = LoggerFactory.getLogger(ApiLhia.class);
    private final WebClient.Builder webClient;
    private final Environment env;
    private final ObjectMapper objectMapper;

    public Mono<TokenKeyCloakModel> getToken() {
        String urlKeycloak = this.env.getProperty("lhia.keycloak");
        return ((WebClient.RequestBodySpec)this.webClient.build().post().uri(urlKeycloak + "/token", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((String)"username", (String)"crea").with("password", (Object)"crea.2012").with("client_id", (Object)"logueoBack").with("grant_type", (Object)"password")).retrieve().bodyToMono(TokenKeyCloakModel.class);
    }

    public Mono<String> getSignOut(String refreshToken) {
        log.warn("CERRANDO LA SESION DEL TOKEN");
        String urlKeycloak = this.env.getProperty("lhia.keycloak");
        return ((WebClient.RequestBodySpec)this.webClient.build().post().uri(urlKeycloak + "/logout", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((String)"refresh_token", (String)refreshToken).with("client_id", (Object)"logueoBack")).retrieve().bodyToMono(String.class);
    }

    public Mono<ResponseLhia> sendMesssageToLhia(RequestQuestionLhia data, String token) {
        String API_URL = this.env.getProperty("lhiaMarcimex.api.sendmessages").concat("/marcimex/questionV2");
        log.info(API_URL);
        log.info("REQUEST MESSAGE TO LHIA {}", (Object)data);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        Map body = new HashMap();
        try {
            body = (Map)this.objectMapper.convertValue((Object)data, Map.class);
        }
        catch (IllegalArgumentException e) {
            return Mono.error((Throwable)new RuntimeException("Error converting WebHookModel to Map", e));
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().bodyToMono(ResponseLhia.class).flatMap(response -> {
            log.info("response lhia {}", response);
            return Mono.just((Object)response);
        });
    }

    public Mono<ResponseLhiaEvent> sendEventToLhia(RequestQuestionLhia data, String token) {
        String API_URL = this.env.getProperty("lhiaMarcimex.api.sendmessages").concat("/purchase/saveActivity");
        log.info(API_URL);
        log.info("REQUEST EVENT TO LHIA {}", (Object)data);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        Map body = new HashMap();
        try {
            body = (Map)this.objectMapper.convertValue((Object)data, Map.class);
        }
        catch (IllegalArgumentException e) {
            return Mono.error((Throwable)new RuntimeException("Error converting WebHookModel to Map", e));
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(body).retrieve().bodyToMono(ResponseLhiaEvent.class).flatMap(response -> {
            log.info("response lhia {}", response);
            return Mono.just((Object)response);
        });
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public Environment getEnv() {
        return this.env;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiLhia)) {
            return false;
        }
        ApiLhia other = (ApiLhia)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiLhia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    public String toString() {
        return "ApiLhia(webClient=" + String.valueOf(this.getWebClient()) + ", env=" + String.valueOf(this.getEnv()) + ", objectMapper=" + String.valueOf(this.getObjectMapper()) + ")";
    }

    public ApiLhia(WebClient.Builder webClient, Environment env, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.env = env;
        this.objectMapper = objectMapper;
    }
}

