/*
 * Decompiled with CFR 0.152.
 */
package com.messenger.marci.auth;

import com.messenger.marci.auth.JwtAuthConverter;
import com.messenger.marci.config.ApiKeyConfig;
import com.messenger.marci.interceptors.CustomAccessDeniedHandler;
import com.messenger.marci.interceptors.CustomAuthenticationEntryPoint;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.web.server.WebFilter;
import reactor.util.context.ContextView;

@Configuration
@EnableWebFluxSecurity
public class WebSecurityConfig {
    private final JwtAuthConverter jwtAuthConverter;
    private final CustomAuthenticationEntryPoint customAuthenticationEntryPoint;
    private final CustomAccessDeniedHandler customAccessDeniedHandler;
    private final ApiKeyConfig apiKeyConfig;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter, CustomAuthenticationEntryPoint customAuthenticationEntryPoint, CustomAccessDeniedHandler customAccessDeniedHandler, ApiKeyConfig apiKeyConfig) {
        this.apiKeyConfig = apiKeyConfig;
        this.jwtAuthConverter = jwtAuthConverter;
        this.customAuthenticationEntryPoint = customAuthenticationEntryPoint;
        this.customAccessDeniedHandler = customAccessDeniedHandler;
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        return http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((ServerAccessDeniedHandler)this.customAccessDeniedHandler)).authorizeExchange(authorize -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorize.pathMatchers(new String[]{"/actuator/info"})).permitAll().pathMatchers(new String[]{"/actuator/health"})).permitAll().pathMatchers(new String[]{"/webhook"})).permitAll().pathMatchers(new String[]{"/tsa/message"})).permitAll().pathMatchers(new String[]{"/ms/**"})).authenticated().anyExchange().authenticated()).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.jwtAuthConverter))).csrf(ServerHttpSecurity.CsrfSpec::disable).addFilterAt(this.apiKeyAuthenticationFilter(), SecurityWebFiltersOrder.AUTHENTICATION).build();
    }

    private WebFilter apiKeyAuthenticationFilter() {
        return (exchange, chain) -> {
            String path = exchange.getRequest().getURI().getPath();
            System.out.println("Ruta solicitada: " + path);
            if (path.startsWith(this.apiKeyConfig.getBasePath() + "ms/")) {
                String receivedKey = exchange.getRequest().getHeaders().getFirst(this.apiKeyConfig.getHeader());
                if (this.apiKeyConfig.getValue().equals(receivedKey)) {
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"apiKeyUser", null, List.of());
                    return chain.filter(exchange).contextWrite((ContextView)ReactiveSecurityContextHolder.withAuthentication((Authentication)auth));
                }
                return this.customAuthenticationEntryPoint.commence(exchange, (AuthenticationException)new /* Unavailable Anonymous Inner Class!! */);
            }
            return chain.filter(exchange);
        };
    }
}

