/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.interceptors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class AuditingWebFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(AuditingWebFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        long startTime = System.currentTimeMillis();
        exchange.getAttributes().put("startTime", startTime);
        return chain.filter(exchange).doOnEach(signal -> {
            if (signal.isOnComplete() || signal.isOnError()) {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                log.info("Request completed in {} ms", (Object)duration);
            }
        });
    }
}

