/*
 * Decompiled with CFR 0.152.
 */
package com.gateway.auth;

import com.gateway.auth.JwtAuthConverter;
import com.gateway.interceptors.CustomAccessDeniedHandler;
import com.gateway.interceptors.CustomAuthenticationEntryPoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;

@Configuration
@EnableWebFluxSecurity
public class WebSecurityConfig {
    private final JwtAuthConverter jwtAuthConverter;
    private final CustomAuthenticationEntryPoint customAuthenticationEntryPoint;
    private final CustomAccessDeniedHandler customAccessDeniedHandler;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter, CustomAuthenticationEntryPoint customAuthenticationEntryPoint, CustomAccessDeniedHandler customAccessDeniedHandler) {
        this.jwtAuthConverter = jwtAuthConverter;
        this.customAuthenticationEntryPoint = customAuthenticationEntryPoint;
        this.customAccessDeniedHandler = customAccessDeniedHandler;
    }

    @Bean
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        http.exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)this.customAuthenticationEntryPoint).accessDeniedHandler((ServerAccessDeniedHandler)this.customAccessDeniedHandler)).authorizeExchange(authorize -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorize.pathMatchers(new String[]{"/actuator/info"})).permitAll().pathMatchers(new String[]{"/actuator/health"})).permitAll().pathMatchers(new String[]{"/lhia-flow/image/chat-marcimex/**"})).permitAll().pathMatchers(new String[]{"/lhia-flow/**"})).permitAll().pathMatchers(new String[]{"/whatsapp/webhook/test"})).permitAll().pathMatchers(new String[]{"/whatsapp/webhook"})).permitAll().pathMatchers(new String[]{"/whatsapp/webhook/sendMessageToAsesorFromApiStatus"})).permitAll().pathMatchers(new String[]{"/whatsapp/webhook/tsa/**"})).permitAll().pathMatchers(new String[]{"/agent/webhook/tsa/**"})).permitAll().pathMatchers(new String[]{"/whatsapp/api/**"})).permitAll().pathMatchers(new String[]{"/whatsapp/lhia/**"})).permitAll().pathMatchers(new String[]{"/whatsapp/state/**"})).permitAll().pathMatchers(new String[]{"/whatsapp/history-conversation/conversation"})).permitAll().pathMatchers(new String[]{"/whatsapp/history-conversation/conversation-item"})).permitAll().pathMatchers(new String[]{"/whatsapp/history-conversation/migrate-conversation"})).permitAll().pathMatchers(new String[]{"/whatsapp/history-conversation/messages-for-day"})).permitAll().pathMatchers(new String[]{"/whatsapp/history-conversation/report-information"})).permitAll().pathMatchers(new String[]{"/whatsapp/tsa/message"})).permitAll().pathMatchers(new String[]{"/whatsapp/imagen-url/**"})).permitAll().pathMatchers(new String[]{"/web-motopower/chat-bp/js/script_motopower.js"})).permitAll().pathMatchers(new String[]{"/whatsapp-marci-test/**"})).permitAll().pathMatchers(new String[]{"/messenger/**"})).permitAll().pathMatchers(new String[]{"/web-marci/**"})).permitAll().pathMatchers(new String[]{"/web-motopower/**"})).permitAll().pathMatchers(new String[]{"/whatsapp-point-test/**"})).permitAll().anyExchange().authenticated()).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.jwtAuthConverter))).csrf(ServerHttpSecurity.CsrfSpec::disable);
        return http.build();
    }
}

