/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.service.impl;

import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.data.PaginadorResponse;
import tws.command.center.command.center.entity.views.ViewInteractionsReport;
import tws.command.center.command.center.repository.view.ViewInteractionsReportDAO;
import tws.command.center.command.center.service.InteractionReportService;

@Service
public class ViewInteractionsReportImpl
implements InteractionReportService {
    private final ViewInteractionsReportDAO interactionsReportDAO;

    public Mono<PaginadorResponse> getInteractionsReport(int page, int size, String initDate, String endDate) {
        Mono totalMono = this.interactionsReportDAO.countAll(initDate, endDate);
        return this.interactionsReportDAO.findAllByDatePaged(page, size, initDate, endDate).collectList().zipWith(totalMono, (data, total) -> {
            PaginadorResponse response = new PaginadorResponse();
            response.setContent(data);
            response.setTotalElements(Integer.valueOf(total.intValue()));
            response.setPage(Integer.valueOf(page));
            response.setSize(Integer.valueOf(size));
            int totalPages = (int)Math.ceil((double)total.longValue() / (double)size);
            response.setTotalPages(Integer.valueOf(totalPages > 0 ? totalPages - 1 : 0));
            return response;
        });
    }

    public Flux<ViewInteractionsReport> getInteractionsReport(String initDate, String endDate) {
        return this.interactionsReportDAO.findAllByDate(initDate, endDate);
    }

    public ViewInteractionsReportImpl(ViewInteractionsReportDAO interactionsReportDAO) {
        this.interactionsReportDAO = interactionsReportDAO;
    }
}

