/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.service.impl;

import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.client.correo.api.MailApiService;
import tws.command.center.command.center.entity.TNotifiedError;
import tws.command.center.command.center.models.MailModel;
import tws.command.center.command.center.repository.NotifiesErrorDAO;
import tws.command.center.command.center.repository.UsersToNotifyErrorDAO;
import tws.command.center.command.center.service.MailService;
import tws.command.center.command.center.utils.MessagesUtil;

@Service
public class MailServiceImpl
implements MailService {
    private static final Logger log = LoggerFactory.getLogger(MailServiceImpl.class);
    private final UsersToNotifyErrorDAO usersToNotifyErrorDAO;
    private final NotifiesErrorDAO notifiesErrorDAO;
    private final MailApiService mailApiService;

    public Mono<String> notificarError(String error) {
        String prefix = error.startsWith("5") ? "5" : "4";
        Flux emailFlux = this.usersToNotifyErrorDAO.findByNotifyWhenErrorStartingWith(prefix).flatMap(mails -> Mono.just((Object)mails.getEmail()));
        return emailFlux.collectList().flatMap(emailList -> {
            MailModel mailModel = new MailModel();
            mailModel.setDestinatarios(emailList);
            mailModel.setAsunto("SERVICIO DE NOTIFIACIONES DE TWS2");
            mailModel.setCodigoEmail("KRLlILAqJsigWtQrAc1UiwtMA0sMnueD");
            mailModel.setContenido(MessagesUtil.getTemplateHTML((String)error));
            mailModel.setContentisHtml(Boolean.valueOf(true));
            return this.mailApiService.getTokenMail().flatMap(tokenModel -> this.mailApiService.sendMailNotification((Object)mailModel, tokenModel.getAccessToken()).flatMap(responseEmail -> {
                log.info("respuesta email service {}", responseEmail);
                String emailString = mailModel.getDestinatarios().stream().collect(Collectors.joining(";"));
                TNotifiedError notifiedMessage = new TNotifiedError(emailString, error);
                return this.notifiesErrorDAO.save((Object)notifiedMessage).then(this.mailApiService.getSignOut(tokenModel.getRefreshToken()));
            }));
        });
    }

    public MailServiceImpl(UsersToNotifyErrorDAO usersToNotifyErrorDAO, NotifiesErrorDAO notifiesErrorDAO, MailApiService mailApiService) {
        this.usersToNotifyErrorDAO = usersToNotifyErrorDAO;
        this.notifiesErrorDAO = notifiesErrorDAO;
        this.mailApiService = mailApiService;
    }
}

