/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.entity.TDetailConversation;
import tws.command.center.command.center.repository.ConversationDAO;
import tws.command.center.command.center.repository.DetailConversationDAO;
import tws.command.center.command.center.service.DetailConversationService;

@Service
public class DetailConversationServiceImpl
implements DetailConversationService {
    private static final Logger log = LoggerFactory.getLogger(DetailConversationServiceImpl.class);
    private final DetailConversationDAO detailConversationDAO;
    private final ConversationDAO conversationDAO;

    public Mono<Void> saveMessageCallback(String roomId, String text, String contentType, String fileName, String type, String url, String origin) {
        return this.conversationDAO.findIdByRoomId(roomId).doOnSubscribe(subscription -> log.info("Finding Conversation ID by Chat ID")).switchIfEmpty(Mono.defer(() -> {
            log.warn("No Conversation ID found for roomId: {}", (Object)roomId);
            return Mono.empty();
        })).doOnNext(conversationId -> log.info("Conversation ID found - {}", conversationId)).flatMap(conversationId -> {
            TDetailConversation detailConversation = new TDetailConversation(type, text, url, fileName, contentType, conversationId, origin);
            return this.detailConversationDAO.save((Object)detailConversation).doOnSuccess(saved -> log.info("Detail Conversation saved - {}", saved)).doOnError(e -> log.error("Error in saving detailConversation", e));
        }).doOnError(e -> log.error("Error in saveMessageCallback process", e)).doOnTerminate(() -> log.info("saveMessageCallback Process Completed")).then();
    }

    public Mono<Void> saveSentUserMessage(String conversationChatId, String text, String type, String url) {
        log.info("Starting saveSentUserMessage process");
        return this.conversationDAO.findIdByConversationChatId(conversationChatId).doOnNext(conversationId -> log.info("Conversation ID found - {}", conversationId)).flatMap(conversationId -> {
            TDetailConversation detailConversation = new TDetailConversation(text, conversationId, type, url, "User");
            return this.detailConversationDAO.save((Object)detailConversation).doOnSuccess(saved -> log.info("Completed: Detail Conversation saved - {}", saved));
        }).doOnError(e -> log.error("Error in saveSentUserMessage", e)).doOnTerminate(() -> log.info("saveSentUserMessage Process Completed")).then();
    }

    public DetailConversationDAO getDetailConversationDAO() {
        return this.detailConversationDAO;
    }

    public ConversationDAO getConversationDAO() {
        return this.conversationDAO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailConversationServiceImpl)) {
            return false;
        }
        DetailConversationServiceImpl other = (DetailConversationServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DetailConversationDAO this$detailConversationDAO = this.getDetailConversationDAO();
        DetailConversationDAO other$detailConversationDAO = other.getDetailConversationDAO();
        if (this$detailConversationDAO == null ? other$detailConversationDAO != null : !this$detailConversationDAO.equals(other$detailConversationDAO)) {
            return false;
        }
        ConversationDAO this$conversationDAO = this.getConversationDAO();
        ConversationDAO other$conversationDAO = other.getConversationDAO();
        return !(this$conversationDAO == null ? other$conversationDAO != null : !this$conversationDAO.equals(other$conversationDAO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DetailConversationServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DetailConversationDAO $detailConversationDAO = this.getDetailConversationDAO();
        result = result * 59 + ($detailConversationDAO == null ? 43 : $detailConversationDAO.hashCode());
        ConversationDAO $conversationDAO = this.getConversationDAO();
        result = result * 59 + ($conversationDAO == null ? 43 : $conversationDAO.hashCode());
        return result;
    }

    public String toString() {
        return "DetailConversationServiceImpl(detailConversationDAO=" + String.valueOf(this.getDetailConversationDAO()) + ", conversationDAO=" + String.valueOf(this.getConversationDAO()) + ")";
    }

    public DetailConversationServiceImpl(DetailConversationDAO detailConversationDAO, ConversationDAO conversationDAO) {
        this.detailConversationDAO = detailConversationDAO;
        this.conversationDAO = conversationDAO;
    }
}

