/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.data.ConversationDetailDTO;
import tws.command.center.command.center.entity.TConversation;
import tws.command.center.command.center.repository.ConversationDAO;
import tws.command.center.command.center.repository.DetailConversationDAO;
import tws.command.center.command.center.service.ConversationService;

@Service
public class ConversationServiceImpl
implements ConversationService {
    private static final Logger log = LoggerFactory.getLogger(ConversationServiceImpl.class);
    private final ConversationDAO conversationDAO;
    private final DetailConversationDAO detailConversationDAO;

    public Mono<Void> saveConversation(String conversationId, String callbackId, String conversationChatId, String roomId, String channel) {
        TConversation conversation = new TConversation(conversationId, callbackId, conversationChatId, roomId, channel);
        log.info("Saving conversation {}", (Object)conversation);
        return this.conversationDAO.save((Object)conversation).doOnSuccess(saved -> log.info("Conversation saved")).then();
    }

    public Mono<ConversationDetailDTO> findConversationChatIdAndChannelByRoomId(String roomId) {
        return this.conversationDAO.findConversationChatIdAndChannelByRoomId(roomId);
    }

    public Mono<String> findConcersationChatIdByRoomId(String roomId) {
        return this.conversationDAO.findConversationChatIdByRoomId(roomId);
    }

    public Mono<String> findConcersationIdByRoomId(String roomId) {
        return this.conversationDAO.findConversationIdByRoomId(roomId);
    }

    public Mono<Long> findIdByConversationChatId(String conversationChatId) {
        return this.conversationDAO.findIdByConversationChatId(conversationChatId);
    }

    public Mono<String> findRoomIdByConversationChatId(String conversationChatId) {
        return this.conversationDAO.findRoomIdByConversationChatId(conversationChatId);
    }

    public Flux<?> getConversationsByRoomId(String roomId) {
        return this.conversationDAO.findIdByRoomId(roomId).doOnSuccess(ids -> log.info("Ids: {}", ids)).flatMapMany(id -> this.detailConversationDAO.findDetailConversationByConversationIdOrderByCreatedAtDesc(id));
    }

    public ConversationDAO getConversationDAO() {
        return this.conversationDAO;
    }

    public DetailConversationDAO getDetailConversationDAO() {
        return this.detailConversationDAO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationServiceImpl)) {
            return false;
        }
        ConversationServiceImpl other = (ConversationServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ConversationDAO this$conversationDAO = this.getConversationDAO();
        ConversationDAO other$conversationDAO = other.getConversationDAO();
        if (this$conversationDAO == null ? other$conversationDAO != null : !this$conversationDAO.equals(other$conversationDAO)) {
            return false;
        }
        DetailConversationDAO this$detailConversationDAO = this.getDetailConversationDAO();
        DetailConversationDAO other$detailConversationDAO = other.getDetailConversationDAO();
        return !(this$detailConversationDAO == null ? other$detailConversationDAO != null : !this$detailConversationDAO.equals(other$detailConversationDAO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationDAO $conversationDAO = this.getConversationDAO();
        result = result * 59 + ($conversationDAO == null ? 43 : $conversationDAO.hashCode());
        DetailConversationDAO $detailConversationDAO = this.getDetailConversationDAO();
        result = result * 59 + ($detailConversationDAO == null ? 43 : $detailConversationDAO.hashCode());
        return result;
    }

    public String toString() {
        return "ConversationServiceImpl(conversationDAO=" + String.valueOf(this.getConversationDAO()) + ", detailConversationDAO=" + String.valueOf(this.getDetailConversationDAO()) + ")";
    }

    public ConversationServiceImpl(ConversationDAO conversationDAO, DetailConversationDAO detailConversationDAO) {
        this.conversationDAO = conversationDAO;
        this.detailConversationDAO = detailConversationDAO;
    }
}

