/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.service.impl;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.client.marcimex.models.PbxFileMessageReqModel;
import tws.command.center.command.center.client.marcimex.models.PbxMessageReqModel;
import tws.command.center.command.center.client.marcimex.service.MarcimexService;
import tws.command.center.command.center.client.marcimex.utils.MarcimexCallbackUtils;
import tws.command.center.command.center.models.RequestChatModel;
import tws.command.center.command.center.models.RequestStartConversationModelMarcimex;
import tws.command.center.command.center.service.ChatServiceEvents;
import tws.command.center.command.center.service.ConversationService;
import tws.command.center.command.center.service.DetailConversationService;
import tws.command.center.command.center.utils.MarcimexUtils;

@Service
public class ChatServiceImpl
implements ChatServiceEvents {
    private static final Logger log = LoggerFactory.getLogger(ChatServiceImpl.class);
    private final MarcimexService marcimexService;
    private final ConversationService conversationService;
    private final MarcimexCallbackUtils marcimexCallbackUtils;
    private final DetailConversationService detailConversationService;

    public Mono<Map<String, Object>> startChatting(RequestStartConversationModelMarcimex body) {
        String conversationChatId = body.getConversationChatId();
        String event = MarcimexUtils.EVENT_START_CHATTING;
        String type = MarcimexUtils.TYPE_EVENT;
        String nick = body.getNick() == null ? "" : body.getNick();
        String channel = body.getChannel() == null ? "" : body.getChannel();
        log.info("Starting chat with id: {}, type: {}, event: {}, nick {}, channel {}", new Object[]{conversationChatId, type, event, body.getNick(), body.getChannel()});
        HashMap<String, String> ob = new HashMap<String, String>();
        ob.put("type", "");
        return this.marcimexCallbackUtils.getUrlCallbackIdFromCode(body.getCallbackId()).flatMap(urlCallback -> this.marcimexService.startChatting(conversationChatId, type, event, nick, channel, urlCallback).flatMap(res -> {
            if (res instanceof Map) {
                Map responseObj = res;
                return this.conversationService.saveConversation(body.getConversationId(), body.getCallbackId(), conversationChatId, responseObj.get("roomId").toString(), body.getChannel()).thenReturn(res);
            }
            return Mono.just((Object)res);
        }).switchIfEmpty(this.fetchDataFromRepository(body.getConversationId())));
    }

    private Mono<Map<String, Object>> fetchDataFromRepository(String conversationChatId) {
        return this.conversationService.findRoomIdByConversationChatId(conversationChatId).map(data -> {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Existe un roomId abierto");
            response.put("roomId", (String)data);
            response.put("conversationChatId", conversationChatId);
            return response;
        });
    }

    public Mono<?> sendMessage(RequestChatModel requestChat) {
        String json;
        log.info("Sending message and saving {}", (Object)requestChat);
        if (requestChat.getType() != null && (MarcimexUtils.TYPE_MESSAGE.equals(requestChat.getType()) || MarcimexUtils.TYPE_LOCATION_PAYLOAD.equals(requestChat.getType()))) {
            String TYPE_PAYLOAD = MarcimexUtils.TYPE_MESSAGE_PAYLOAD;
            switch (requestChat.getType()) {
                case "message": {
                    TYPE_PAYLOAD = MarcimexUtils.TYPE_MESSAGE_PAYLOAD;
                    break;
                }
                case "location": {
                    TYPE_PAYLOAD = MarcimexUtils.TYPE_LOCATION_PAYLOAD;
                    break;
                }
                default: {
                    TYPE_PAYLOAD = MarcimexUtils.TYPE_MESSAGE_PAYLOAD;
                }
            }
            PbxMessageReqModel requestMessage = new PbxMessageReqModel(requestChat.getConversationChatId(), MarcimexUtils.TYPE_MESSAGE, TYPE_PAYLOAD, requestChat.getMessage(), requestChat.getChannel(), requestChat.getNick(), requestChat.getLongitude(), requestChat.getLatitude());
            json = new Gson().toJson((Object)requestMessage);
        } else {
            PbxFileMessageReqModel requestFile = new PbxFileMessageReqModel(requestChat.getConversationChatId(), MarcimexUtils.TYPE_MESSAGE, requestChat.getType(), requestChat.getContentType(), requestChat.getFileName(), requestChat.getFile(), requestChat.getChannel(), requestChat.getNick());
            json = new Gson().toJson((Object)requestFile);
        }
        return this.marcimexCallbackUtils.getUrlCallbackIdFromCode(requestChat.getCallbackId()).doOnNext(urlCallback -> log.info("Completed: Room ID from Code - {}", urlCallback)).flatMap(urlCallback -> this.marcimexService.sendMessage(json, urlCallback).doOnNext(response -> log.info("Message sent to Marcimex Service - {}", response)).doOnError(e -> log.error("Error: Sending message to Marcimex Service", e)).flatMap(response -> {
            if (response instanceof Map && response.containsKey("roomId")) {
                log.info("response: {}" + String.valueOf(response));
                String roomId = response.get("roomId").toString();
                return this.conversationService.saveConversation(requestChat.getConversationId(), requestChat.getCallbackId(), requestChat.getConversationChatId(), roomId, requestChat.getChannel()).thenReturn(response);
            }
            log.info("Response from Marcimex Service: {}", response);
            return Mono.just((Object)response);
        }).switchIfEmpty(Mono.just(Collections.emptyMap())).onErrorResume(e -> {
            log.error("Handling error in Step 2, continuing to save the message", e);
            return Mono.just(Collections.emptyMap());
        })).flatMap(response -> this.saveSentUserMessage(requestChat.getConversationChatId(), requestChat.getMessage(), requestChat.getType(), requestChat.getFile()).thenReturn(response)).doOnTerminate(() -> log.info("Process Completed")).doOnError(e -> log.error("Error in sendMessage process", e)).then();
    }

    public Mono<Void> saveSentUserMessage(String conversationChatId, String text, String type, String url) {
        log.info("Starting saveSentUserMessage process");
        return this.conversationService.findRoomIdByConversationChatId(conversationChatId).doOnNext(conversationId -> log.info("Conversation ID found - {}", conversationId)).flatMap(conversationId -> this.detailConversationService.saveSentUserMessage(conversationChatId, text, type, url).doOnSuccess(saved -> log.info("Completed: Detail Conversation saved - {}", saved))).doOnError(e -> log.error("Error in saveSentUserMessage", e)).doOnTerminate(() -> log.info("saveSentUserMessage Process Completed")).then();
    }

    public Mono<?> closeChat(String conversationId) {
        return this.marcimexService.closeRoomId(conversationId);
    }

    public MarcimexService getMarcimexService() {
        return this.marcimexService;
    }

    public ConversationService getConversationService() {
        return this.conversationService;
    }

    public MarcimexCallbackUtils getMarcimexCallbackUtils() {
        return this.marcimexCallbackUtils;
    }

    public DetailConversationService getDetailConversationService() {
        return this.detailConversationService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatServiceImpl)) {
            return false;
        }
        ChatServiceImpl other = (ChatServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        MarcimexService this$marcimexService = this.getMarcimexService();
        MarcimexService other$marcimexService = other.getMarcimexService();
        if (this$marcimexService == null ? other$marcimexService != null : !this$marcimexService.equals(other$marcimexService)) {
            return false;
        }
        ConversationService this$conversationService = this.getConversationService();
        ConversationService other$conversationService = other.getConversationService();
        if (this$conversationService == null ? other$conversationService != null : !this$conversationService.equals(other$conversationService)) {
            return false;
        }
        MarcimexCallbackUtils this$marcimexCallbackUtils = this.getMarcimexCallbackUtils();
        MarcimexCallbackUtils other$marcimexCallbackUtils = other.getMarcimexCallbackUtils();
        if (this$marcimexCallbackUtils == null ? other$marcimexCallbackUtils != null : !this$marcimexCallbackUtils.equals(other$marcimexCallbackUtils)) {
            return false;
        }
        DetailConversationService this$detailConversationService = this.getDetailConversationService();
        DetailConversationService other$detailConversationService = other.getDetailConversationService();
        return !(this$detailConversationService == null ? other$detailConversationService != null : !this$detailConversationService.equals(other$detailConversationService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MarcimexService $marcimexService = this.getMarcimexService();
        result = result * 59 + ($marcimexService == null ? 43 : $marcimexService.hashCode());
        ConversationService $conversationService = this.getConversationService();
        result = result * 59 + ($conversationService == null ? 43 : $conversationService.hashCode());
        MarcimexCallbackUtils $marcimexCallbackUtils = this.getMarcimexCallbackUtils();
        result = result * 59 + ($marcimexCallbackUtils == null ? 43 : $marcimexCallbackUtils.hashCode());
        DetailConversationService $detailConversationService = this.getDetailConversationService();
        result = result * 59 + ($detailConversationService == null ? 43 : $detailConversationService.hashCode());
        return result;
    }

    public String toString() {
        return "ChatServiceImpl(marcimexService=" + String.valueOf(this.getMarcimexService()) + ", conversationService=" + String.valueOf(this.getConversationService()) + ", marcimexCallbackUtils=" + String.valueOf(this.getMarcimexCallbackUtils()) + ", detailConversationService=" + String.valueOf(this.getDetailConversationService()) + ")";
    }

    public ChatServiceImpl(MarcimexService marcimexService, ConversationService conversationService, MarcimexCallbackUtils marcimexCallbackUtils, DetailConversationService detailConversationService) {
        this.marcimexService = marcimexService;
        this.conversationService = conversationService;
        this.marcimexCallbackUtils = marcimexCallbackUtils;
        this.detailConversationService = detailConversationService;
    }
}

