/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.models.RequestChatModel;
import tws.command.center.command.center.models.RequestStartConversationModelMarcimex;
import tws.command.center.command.center.service.ChatServiceEvents;
import tws.command.center.command.center.service.ConversationService;
import tws.command.center.command.center.service.FileService;
import tws.command.center.command.center.service.MailService;
import tws.command.center.command.center.utils.MarcimexUtils;

@RestController
@RequestMapping(value={"chat"})
public class ChatController {
    private static final Logger log = LoggerFactory.getLogger(ChatController.class);
    private final ChatServiceEvents chatServiceEvents;
    private final FileService fileService;
    private final Environment env;
    private final ConversationService conversationService;
    private final ObjectMapper mapper;
    private final MailService mailService;

    @PostMapping(value={"start-chatting"})
    public Mono<?> startChatting(@RequestBody RequestStartConversationModelMarcimex body) {
        log.info("Starting chat with: {}", (Object)body);
        return this.chatServiceEvents.startChatting(body);
    }

    @PostMapping(value={"send-message"})
    public Mono<?> sendMessage(@RequestBody RequestChatModel requestChat) {
        log.info("Sending message: {}", (Object)requestChat);
        if (requestChat.getType().equals("text")) {
            requestChat.setType(MarcimexUtils.TYPE_MESSAGE);
        }
        if (requestChat.getType().equals("document")) {
            requestChat.setType(MarcimexUtils.TYPE_PDF);
        }
        if (requestChat.getType() != null && (MarcimexUtils.TYPE_MESSAGE.equals(requestChat.getType()) || MarcimexUtils.TYPE_LOCATION.equals(requestChat.getType()))) {
            return this.chatServiceEvents.sendMessage(requestChat).then().onErrorResume(e -> {
                log.error("Error sending message", e);
                return Mono.empty();
            });
        }
        return this.chatServiceEvents.sendMessage(requestChat);
    }

    @PostMapping(value={"close-room"})
    public Mono<?> closeRoom(@RequestBody Map<String, String> body) {
        log.info("Closing room: {}", body);
        return this.chatServiceEvents.closeChat(body.get("roomId"));
    }

    @PostMapping(value={"getConversation"})
    public Flux<?> getConversation(@RequestBody Map<String, String> body) {
        log.info("Getting conversation: {}", body);
        return this.conversationService.getConversationsByRoomId(body.get("roomId").toString());
    }

    @PostMapping(value={"test"})
    public Mono<String> postMethodName(@RequestBody Map data) {
        log.info("POST request received {}", (Object)data);
        return this.mailService.notificarError("4");
    }

    public ChatServiceEvents getChatServiceEvents() {
        return this.chatServiceEvents;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public Environment getEnv() {
        return this.env;
    }

    public ConversationService getConversationService() {
        return this.conversationService;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatController)) {
            return false;
        }
        ChatController other = (ChatController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ChatServiceEvents this$chatServiceEvents = this.getChatServiceEvents();
        ChatServiceEvents other$chatServiceEvents = other.getChatServiceEvents();
        if (this$chatServiceEvents == null ? other$chatServiceEvents != null : !this$chatServiceEvents.equals(other$chatServiceEvents)) {
            return false;
        }
        FileService this$fileService = this.getFileService();
        FileService other$fileService = other.getFileService();
        if (this$fileService == null ? other$fileService != null : !this$fileService.equals(other$fileService)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        ConversationService this$conversationService = this.getConversationService();
        ConversationService other$conversationService = other.getConversationService();
        if (this$conversationService == null ? other$conversationService != null : !this$conversationService.equals(other$conversationService)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        MailService this$mailService = this.getMailService();
        MailService other$mailService = other.getMailService();
        return !(this$mailService == null ? other$mailService != null : !this$mailService.equals(other$mailService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChatServiceEvents $chatServiceEvents = this.getChatServiceEvents();
        result = result * 59 + ($chatServiceEvents == null ? 43 : $chatServiceEvents.hashCode());
        FileService $fileService = this.getFileService();
        result = result * 59 + ($fileService == null ? 43 : $fileService.hashCode());
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        ConversationService $conversationService = this.getConversationService();
        result = result * 59 + ($conversationService == null ? 43 : $conversationService.hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        MailService $mailService = this.getMailService();
        result = result * 59 + ($mailService == null ? 43 : $mailService.hashCode());
        return result;
    }

    public String toString() {
        return "ChatController(chatServiceEvents=" + String.valueOf(this.getChatServiceEvents()) + ", fileService=" + String.valueOf(this.getFileService()) + ", env=" + String.valueOf(this.getEnv()) + ", conversationService=" + String.valueOf(this.getConversationService()) + ", mapper=" + String.valueOf(this.getMapper()) + ", mailService=" + String.valueOf(this.getMailService()) + ")";
    }

    public ChatController(ChatServiceEvents chatServiceEvents, FileService fileService, Environment env, ConversationService conversationService, ObjectMapper mapper, MailService mailService) {
        this.chatServiceEvents = chatServiceEvents;
        this.fileService = fileService;
        this.env = env;
        this.conversationService = conversationService;
        this.mapper = mapper;
        this.mailService = mailService;
    }
}

