/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.client.marcimex.models.MarcimexCallbackResponse;
import tws.command.center.command.center.client.marcimex.service.MarcimexCallbackService;
import tws.command.center.command.center.service.ConversationService;
import tws.command.center.command.center.service.DetailConversationService;

@RestController
@RequestMapping(value={"api/v1/callback"})
public class ChatCallbackController {
    private static final Logger log = LoggerFactory.getLogger(ChatCallbackController.class);
    private final Environment env;
    private final MarcimexCallbackService marcimexCallbackService;
    private final ConversationService conversationService;
    private final DetailConversationService detailConversationService;

    @PostMapping(value={"message/1a794350-fb98-4ab9-9142-bd1978be271f"})
    public Mono<?> callbackMarcimex(@RequestBody Map<String, Object> request) {
        log.info("Received callback from Marcimex: {}", request);
        ObjectMapper mapper = new ObjectMapper();
        MarcimexCallbackResponse obj = (MarcimexCallbackResponse)mapper.convertValue(request, MarcimexCallbackResponse.class);
        return this.conversationService.findConversationChatIdAndChannelByRoomId(obj.getRoomId()).flatMap(conversationAllowed -> {
            log.info("Found conversation: {}", conversationAllowed);
            obj.setConversationId(conversationAllowed.getConversationChatId());
            obj.setChannel(conversationAllowed.getChannel());
            return this.marcimexCallbackService.callbackWebHook(obj).doOnNext(response -> log.info("CallbackWebHook whatsapp response: {}", response)).doOnError(e -> log.error("Error in callbackWebHook", e)).thenReturn((Object)conversationAllowed.getConversationChatId());
        }).flatMap(conversationId -> {
            log.info("Saving message callback for roomId: {}", (Object)obj.getRoomId());
            return this.detailConversationService.saveMessageCallback(obj.getRoomId(), obj.getPayload().getText(), obj.getPayload().getContentType(), obj.getPayload().getFileName(), obj.getType(), obj.getPayload().getUrl(), "Asesor").doOnNext(saved -> log.info("Message saved successfully")).doOnError(e -> log.error("Error in saveMessageCallback", e));
        }).doOnError(e -> log.error("Error in processing callbackMarcimex", e)).then();
    }

    public Environment getEnv() {
        return this.env;
    }

    public MarcimexCallbackService getMarcimexCallbackService() {
        return this.marcimexCallbackService;
    }

    public ConversationService getConversationService() {
        return this.conversationService;
    }

    public DetailConversationService getDetailConversationService() {
        return this.detailConversationService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCallbackController)) {
            return false;
        }
        ChatCallbackController other = (ChatCallbackController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        MarcimexCallbackService this$marcimexCallbackService = this.getMarcimexCallbackService();
        MarcimexCallbackService other$marcimexCallbackService = other.getMarcimexCallbackService();
        if (this$marcimexCallbackService == null ? other$marcimexCallbackService != null : !this$marcimexCallbackService.equals(other$marcimexCallbackService)) {
            return false;
        }
        ConversationService this$conversationService = this.getConversationService();
        ConversationService other$conversationService = other.getConversationService();
        if (this$conversationService == null ? other$conversationService != null : !this$conversationService.equals(other$conversationService)) {
            return false;
        }
        DetailConversationService this$detailConversationService = this.getDetailConversationService();
        DetailConversationService other$detailConversationService = other.getDetailConversationService();
        return !(this$detailConversationService == null ? other$detailConversationService != null : !this$detailConversationService.equals(other$detailConversationService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCallbackController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        MarcimexCallbackService $marcimexCallbackService = this.getMarcimexCallbackService();
        result = result * 59 + ($marcimexCallbackService == null ? 43 : $marcimexCallbackService.hashCode());
        ConversationService $conversationService = this.getConversationService();
        result = result * 59 + ($conversationService == null ? 43 : $conversationService.hashCode());
        DetailConversationService $detailConversationService = this.getDetailConversationService();
        result = result * 59 + ($detailConversationService == null ? 43 : $detailConversationService.hashCode());
        return result;
    }

    public String toString() {
        return "ChatCallbackController(env=" + String.valueOf(this.getEnv()) + ", marcimexCallbackService=" + String.valueOf(this.getMarcimexCallbackService()) + ", conversationService=" + String.valueOf(this.getConversationService()) + ", detailConversationService=" + String.valueOf(this.getDetailConversationService()) + ")";
    }

    public ChatCallbackController(Environment env, MarcimexCallbackService marcimexCallbackService, ConversationService conversationService, DetailConversationService detailConversationService) {
        this.env = env;
        this.marcimexCallbackService = marcimexCallbackService;
        this.conversationService = conversationService;
        this.detailConversationService = detailConversationService;
    }
}

