/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.client.marcimex.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.client.marcimex.service.MarcimexSupportService;

@Service
public class MarcimexApiSupportImpl
implements MarcimexSupportService {
    private static final Logger log = LoggerFactory.getLogger(MarcimexApiSupportImpl.class);
    private final Environment env;
    private final WebClient.Builder webClient;

    public Mono<?> createTicket(Object req) {
        return this.makeApiCall(req, "POST");
    }

    public Mono<?> putTicket(Object req) {
        return this.makeApiCall(req, "PUT");
    }

    private Mono<?> makeApiCall(Object requestBody, String method) {
        String username = this.env.getProperty("marcimex.url.zammad.username");
        String password = this.env.getProperty("marcimex.url.zammad.password");
        String zammadUrl = this.env.getProperty("marcimex.url.zammad");
        WebClient.RequestHeadersSpec requestBodySpec = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().method(method.equalsIgnoreCase("POST") ? HttpMethod.POST : HttpMethod.PUT).uri(zammadUrl, new Object[0])).header("Content-Type", new String[]{"application/json"})).headers(headers -> headers.setBasicAuth(username, password))).body(BodyInserters.fromValue((Object)requestBody));
        return requestBodySpec.retrieve().bodyToMono(Object.class).flatMap(response -> {
            System.out.println("Response: " + String.valueOf(response));
            return Mono.just((Object)response);
        }).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            if (!error.getMessage().contains("200 OK from")) {
                log.error("Error making API call", error);
            }
            log.info("This message was sent: {}", requestBody);
            return Mono.empty();
        }).doOnError(error -> log.error("Error making API call to the endpoint", error));
    }

    public Environment getEnv() {
        return this.env;
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarcimexApiSupportImpl)) {
            return false;
        }
        MarcimexApiSupportImpl other = (MarcimexApiSupportImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        return !(this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarcimexApiSupportImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        return result;
    }

    public String toString() {
        return "MarcimexApiSupportImpl(env=" + String.valueOf(this.getEnv()) + ", webClient=" + String.valueOf(this.getWebClient()) + ")";
    }

    public MarcimexApiSupportImpl(Environment env, WebClient.Builder webClient) {
        this.env = env;
        this.webClient = webClient;
    }
}

