/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.ScheduledTasks;

import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import tws.command.center.command.center.repository.FileDAO;

@Component
public class DropOldFilesTask {
    private static final Logger log = LoggerFactory.getLogger(DropOldFilesTask.class);
    private final FileDAO fileDAO;

    @Scheduled(cron="0 0 0 * * ?")
    public void dropOldFilesFromLast5Days() {
        LocalDateTime now = LocalDateTime.now().minusDays(5L);
        log.info("Dropping old files from last 5 days {}", (Object)now);
        this.fileDAO.deleteFilesMoreThan5Days(now).doOnSuccess(result -> log.info("Deleted {} files", result)).doOnError(error -> log.error("Error deleting files", error)).subscribe();
    }

    public DropOldFilesTask(FileDAO fileDAO) {
        this.fileDAO = fileDAO;
    }
}

