/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.service.impl;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.entity.TFile;
import tws.command.center.command.center.repository.FileDAO;
import tws.command.center.command.center.service.FileService;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    private final FileDAO imageRepository;
    private final WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    private final Environment env;

    public Mono<TFile> downloadAndSaveImage(String imageUrl, String fileName) {
        log.info("Downloading file from {}", (Object)imageUrl);
        return this.webClient.get().uri(imageUrl, new Object[0]).retrieve().toEntity(byte[].class).flatMap(response -> {
            String contentType = response.getHeaders().getContentType().toString();
            String filename = this.extractFilename(response.getHeaders().getContentDisposition().getFilename(), fileName);
            log.info("File downloaded successfully with content type {}", (Object)contentType);
            TFile fileContent = new TFile();
            fileContent.setName(filename);
            fileContent.setContentType(contentType);
            return Mono.just((Object)fileContent);
        }).flatMap(img -> {
            log.info("File saved successfully with ID {}", (Object)img.getId());
            return Mono.just((Object)img);
        }).doOnError(e -> log.error("Error saving File", e));
    }

    private String extractFilename(String headerFilename, String defaultName) {
        if (defaultName != null && !defaultName.isEmpty()) {
            return defaultName;
        }
        String uuidFileName = UUID.randomUUID().toString();
        if (headerFilename != null && !headerFilename.isEmpty()) {
            return uuidFileName.concat(headerFilename);
        }
        return uuidFileName.concat(defaultName);
    }

    public Mono<TFile> getImage(UUID id) {
        return this.imageRepository.findById((Object)id);
    }

    public FileServiceImpl(FileDAO imageRepository, Environment env) {
        this.imageRepository = imageRepository;
        this.env = env;
    }
}

