/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.controller;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.service.FileService;

@RestController
@RequestMapping(value={"image"})
public class ImageController {
    private static final Logger log = LoggerFactory.getLogger(ImageController.class);
    private final FileService fileService;

    @GetMapping(value={"download"})
    public Mono<?> downloadImage() {
        return this.fileService.downloadAndSaveImage("https://www.shutterstock.com/image-vector/cute-cat-various-poses-cartoon-600nw-687320254.jpg", "name").map(image -> ResponseEntity.status((int)201).body(image)).onErrorResume(e -> {
            log.error("Error downloading image", e);
            return Mono.just((Object)ResponseEntity.status((int)500).body(null));
        });
    }

    @GetMapping(value={"/chat-marcimex/{id}"})
    public Mono<ResponseEntity<byte[]>> getImage(@PathVariable UUID id) {
        return this.fileService.getImage(id).map(image -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.valueOf((String)image.getContentType()));
            headers.setContentLength((long)image.getData().length);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)image.getData());
        }).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    public ImageController(FileService fileService) {
        this.fileService = fileService;
    }
}

