/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.client.marcimex.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.client.marcimex.models.MarcimexCallbackResponse;
import tws.command.center.command.center.client.marcimex.service.MarcimexCallbackService;

@Service
public class MarcimexCallbackServiceImpl
implements MarcimexCallbackService {
    private static final Logger log = LoggerFactory.getLogger(MarcimexCallbackServiceImpl.class);
    private final Environment env;
    private final WebClient.Builder webClient;

    public Mono<?> callbackWebHook(MarcimexCallbackResponse requestModel) {
        log.info("Sending callback to whatsapp: {}", (Object)requestModel);
        return this.makePostWhatsapp(requestModel);
    }

    public Mono<?> makePostWhatsapp(MarcimexCallbackResponse request) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(this.env.getProperty("whatsapp.api.url") + "/api/asesor", new Object[0])).header("Content-Type", new String[]{"application/json"})).bodyValue((Object)request).retrieve().bodyToMono(String.class).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.empty();
        }).doOnError(error -> log.error("Error making API call", error));
    }

    public Mono<?> makePostWebHook(MarcimexCallbackResponse request) {
        System.out.println(this.env.getProperty("marcimex.url.webhook.botpress"));
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(this.env.getProperty("marcimex.url.webhook.botpress"), new Object[0])).header("Content-Type", new String[]{"application/json"})).bodyValue((Object)request).retrieve().bodyToMono(String.class).doOnSuccess(response -> log.info("API call made successfully with response: {}", response)).onErrorResume(error -> {
            log.error("Error making API call", error);
            return Mono.empty();
        }).doOnError(error -> log.error("Error making API call", error));
    }

    public Environment getEnv() {
        return this.env;
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarcimexCallbackServiceImpl)) {
            return false;
        }
        MarcimexCallbackServiceImpl other = (MarcimexCallbackServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        return !(this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarcimexCallbackServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        return result;
    }

    public String toString() {
        return "MarcimexCallbackServiceImpl(env=" + String.valueOf(this.getEnv()) + ", webClient=" + String.valueOf(this.getWebClient()) + ")";
    }

    public MarcimexCallbackServiceImpl(Environment env, WebClient.Builder webClient) {
        this.env = env;
        this.webClient = webClient;
    }
}

