/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.client.marcimex.api;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import tws.command.center.command.center.client.marcimex.service.MarcimexService;
import tws.command.center.command.center.service.MailService;

@Service
public class MarcimexApiServiceImpl
implements MarcimexService {
    private static final Logger log = LoggerFactory.getLogger(MarcimexApiServiceImpl.class);
    private final Environment env;
    private final WebClient.Builder webClient;
    private final MailService mailService;

    public Mono<Map<String, Object>> startChatting(String conversationId, String type, String event, String nick, String channel, String url) {
        log.info("Making API call to start chatting");
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"id", (Object)conversationId);
        params.add((Object)"type", (Object)type);
        params.add((Object)"event", (Object)event);
        params.add((Object)"nick", (Object)nick);
        params.add((Object)"channel", (Object)channel);
        return this.makePostApiCall(null, (MultiValueMap)headers, (MultiValueMap)params, url, false).flatMap(res -> {
            if (res != null && res instanceof Map) {
                Map responseObj = (Map)res;
                responseObj.put("conversationChatId", conversationId);
                return Mono.just((Object)((Map)res));
            }
            return Mono.just(Collections.emptyMap());
        });
    }

    public Mono<Map<String, Object>> sendMessage(String json, String url) {
        log.info("Sending message to room: {}", (Object)json);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        return this.makePostApiCall(json, (MultiValueMap)headers, null, url, true).flatMap(res -> {
            if (res != null && res instanceof Map) {
                return Mono.just((Object)((Map)res));
            }
            return Mono.just(Collections.emptyMap());
        });
    }

    public Mono<String> closeRoomId(String roomId) {
        String baseUrl = this.env.getProperty("marcimex.api.close.room");
        String url = baseUrl.replace("{roomId}", roomId);
        String token = "Bearer " + this.env.getProperty("marcimex.api.close.room.token");
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().put().uri(url, new Object[0])).headers(headers -> headers.set("Authorization", "Bearer " + token))).retrieve().bodyToMono(String.class);
    }

    public Mono<?> makePostApiCall(String json, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, String url, boolean isJson) {
        log.info("Making API call to: {}", (Object)url);
        WebClient.RequestBodySpec request = (WebClient.RequestBodySpec)this.webClient.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector((HttpClient)HttpClient.create().responseTimeout(Duration.ofSeconds(30L)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000))).build().post().uri(url, new Object[0]);
        headers.forEach((key, values) -> values.forEach(value -> request.header(key, new String[]{value})));
        if (isJson) {
            request.body(BodyInserters.fromValue((Object)json));
        } else {
            request.body((BodyInserter)BodyInserters.fromFormData(params));
        }
        return request.retrieve().bodyToMono(Object.class).flatMap(response -> {
            System.out.println("Response: " + String.valueOf(response));
            return Mono.just((Object)response);
        }).doOnSuccess(response -> System.out.println("API call made successfully with response: " + String.valueOf(response))).onErrorResume(error -> {
            if (!error.getMessage().contains("200 OK from")) {
                System.err.println("Error making API call: " + String.valueOf(error));
                return this.mailService.notificarError(error.getMessage());
            }
            System.err.println("Existe una reunion abierta con el id: " + (String)headers.getFirst((Object)"id"));
            return Mono.empty();
        }).doOnError(error -> System.err.println("Error making API call: " + String.valueOf(error)));
    }

    public Environment getEnv() {
        return this.env;
    }

    public WebClient.Builder getWebClient() {
        return this.webClient;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarcimexApiServiceImpl)) {
            return false;
        }
        MarcimexApiServiceImpl other = (MarcimexApiServiceImpl)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        WebClient.Builder this$webClient = this.getWebClient();
        WebClient.Builder other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        MailService this$mailService = this.getMailService();
        MailService other$mailService = other.getMailService();
        return !(this$mailService == null ? other$mailService != null : !this$mailService.equals(other$mailService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarcimexApiServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        WebClient.Builder $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        MailService $mailService = this.getMailService();
        result = result * 59 + ($mailService == null ? 43 : $mailService.hashCode());
        return result;
    }

    public String toString() {
        return "MarcimexApiServiceImpl(env=" + String.valueOf(this.getEnv()) + ", webClient=" + String.valueOf(this.getWebClient()) + ", mailService=" + String.valueOf(this.getMailService()) + ")";
    }

    public MarcimexApiServiceImpl(Environment env, WebClient.Builder webClient, MailService mailService) {
        this.env = env;
        this.webClient = webClient;
        this.mailService = mailService;
    }
}

