/*
 * Decompiled with CFR 0.152.
 */
package tws.command.center.command.center.client.correo.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import tws.command.center.command.center.client.correo.api.MailApiService;
import tws.command.center.command.center.models.TokenKeyCloakModel;

@Service
public class MailApiServiceImpl
implements MailApiService {
    private static final Logger log = LoggerFactory.getLogger(MailApiServiceImpl.class);
    private final WebClient.Builder webClient;
    private final Environment env;

    public Mono<TokenKeyCloakModel> getTokenMail() {
        String urlKeycloak = this.env.getProperty("mail.keycloak");
        return ((WebClient.RequestBodySpec)this.webClient.build().post().uri(urlKeycloak + "/token", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((String)"username", (String)"emailservice").with("password", (Object)"X}5E&fY\\ca#Y)u*Q").with("client_id", (Object)"logueoBack").with("grant_type", (Object)"password")).retrieve().bodyToMono(TokenKeyCloakModel.class);
    }

    public Mono<String> getSignOut(String refreshToken) {
        log.warn("CERRANDO LA SESION DEL TOKEN");
        String urlKeycloak = this.env.getProperty("mail.keycloak");
        return ((WebClient.RequestBodySpec)this.webClient.build().post().uri(urlKeycloak + "/logout", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)BodyInserters.fromFormData((String)"refresh_token", (String)refreshToken).with("client_id", (Object)"logueoBack")).retrieve().bodyToMono(String.class);
    }

    public Mono<String> sendMailNotification(Object data, String token) {
        String API_URL = this.env.getProperty("mail.api.send");
        log.info(API_URL);
        log.info("REQUEST TO MAIL SERVICE");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.build().post().uri(API_URL, new Object[0])).headers(httpHeaders -> httpHeaders.addAll((MultiValueMap)headers))).bodyValue(data).retrieve().bodyToMono(String.class).flatMap(response -> {
            log.info("response mail {}", response);
            return Mono.just((Object)response);
        });
    }

    public MailApiServiceImpl(WebClient.Builder webClient, Environment env) {
        this.webClient = webClient;
        this.env = env;
    }
}

