/*
 * Decompiled with CFR 0.152.
 */
package io.tws2.back_file_bot.service.impl;

import io.tws2.back_file_bot.common.transactions.TransactionCustom;
import io.tws2.back_file_bot.common.util.FileUtil;
import io.tws2.back_file_bot.dto.StoredFileDTO;
import io.tws2.back_file_bot.entity.TStoredFile;
import io.tws2.back_file_bot.repository.StoredFileDAO;
import io.tws2.back_file_bot.service.StoredFileService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class StoredFileServiceImpl
implements StoredFileService {
    @Value(value="${api.domain.url}")
    private String apiDomainUrl;
    @Autowired
    private StoredFileDAO storedFileDAO;

    public Optional<TStoredFile> findById(String id) {
        UUID uuidFile = UUID.fromString(id);
        return this.storedFileDAO.findById((Object)uuidFile);
    }

    public List<UUID> findIdByFolder(String folder) {
        return this.storedFileDAO.findIdByFolder(folder);
    }

    public ResponseEntity<?> saveStoredFile(StoredFileDTO storedFileDTO) {
        String pathImage = this.apiDomainUrl + "/v1/stored-file/assets/";
        HashMap<String, Object> response = new HashMap<String, Object>();
        Optional storedFileFind = Optional.ofNullable(storedFileDTO.getId()).flatMap(arg_0 -> ((StoredFileDAO)this.storedFileDAO).findByFileId(arg_0));
        TStoredFile storedFile = storedFileFind.orElseGet(() -> {
            TStoredFile newFile = new TStoredFile();
            newFile.setId(UUID.randomUUID());
            return newFile;
        });
        storedFile.setFolder(storedFileDTO.getFolder());
        storedFile.setContentType(FileUtil.determineFileType((String)storedFileDTO.getContentType()));
        storedFile.setFileData(FileUtil.base64ToByte((String)storedFileDTO.getBase64()));
        storedFile.setFileId(storedFileDTO.getId());
        TStoredFile storedFileData = (TStoredFile)this.storedFileDAO.save((Object)storedFile);
        response.put("path", pathImage + String.valueOf(storedFileData.getId()));
        response.put("id", storedFileData.getId());
        return TransactionCustom.ok(response);
    }

    public ResponseEntity<byte[]> findStoredFileById(String id) {
        Optional storedFile = this.findById(id);
        if (storedFile.isPresent()) {
            HttpHeaders headers = new HttpHeaders();
            String fileType = FileUtil.determineFileType((String)((TStoredFile)storedFile.get()).getContentType());
            if (fileType == null) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            headers.setContentType(MediaType.parseMediaType((String)fileType));
            return new ResponseEntity((Object)((TStoredFile)storedFile.get()).getFileData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<byte[]> getByteFileById(String fileId, String rangeHeader, boolean useRange) {
        Optional opt = this.findById(fileId);
        if (opt.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        TStoredFile f = (TStoredFile)opt.get();
        byte[] data = f.getFileData();
        if (data == null || data.length == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        String mime = FileUtil.resolveMime((String)f.getContentType(), (byte[])data);
        HttpHeaders headers = FileUtil.buildInlineHeaders((String)mime, (String)fileId);
        long total = data.length;
        if (!FileUtil.shouldUseRange((boolean)useRange, (String)rangeHeader)) {
            headers.setContentLength(total);
            return new ResponseEntity((Object)data, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        FileUtil.Range r = FileUtil.parseRange((String)rangeHeader, (long)total);
        if (!r.isSatisfiable()) {
            headers.set("Content-Range", "bytes */" + total);
            return new ResponseEntity(null, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
        }
        byte[] slice = FileUtil.slice((byte[])data, (long)r.start, (long)r.end);
        headers.set("Content-Range", String.format("bytes %d-%d/%d", r.start, r.end, total));
        headers.setContentLength((long)slice.length);
        return new ResponseEntity((Object)slice, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.PARTIAL_CONTENT);
    }

    public ResponseEntity<byte[]> getByteFileByIdV2(String fileId, String rangeHeader, boolean useRange) {
        Optional opt = this.findById(fileId);
        if (opt.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        TStoredFile f = (TStoredFile)opt.get();
        byte[] data = f.getFileData();
        if (data == null || data.length == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        String mime = FileUtil.resolveMimeWithoutFilename((String)f.getContentType(), (byte[])data);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)mime));
        headers.set("Accept-Ranges", "bytes");
        headers.setContentDisposition(ContentDisposition.inline().build());
        int fileLength = data.length;
        if (rangeHeader == null || !rangeHeader.startsWith("bytes=")) {
            headers.setContentLength((long)fileLength);
            return new ResponseEntity((Object)data, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        try {
            int end;
            String[] parts = rangeHeader.substring("bytes=".length()).trim().split("-", 2);
            int start = parts[0].isEmpty() ? 0 : Integer.parseInt(parts[0]);
            int n = end = parts.length > 1 && !parts[1].isEmpty() ? Integer.parseInt(parts[1]) : fileLength - 1;
            if (start < 0 || end >= fileLength || start > end) {
                headers.set("Content-Range", "bytes */" + fileLength);
                return new ResponseEntity(null, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
            }
            byte[] slice = Arrays.copyOfRange(data, start, end + 1);
            headers.setContentLength((long)slice.length);
            headers.set("Content-Range", String.format("bytes %d-%d/%d", start, end, fileLength));
            return new ResponseEntity((Object)slice, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.PARTIAL_CONTENT);
        }
        catch (Exception e) {
            headers.setContentLength((long)fileLength);
            return new ResponseEntity((Object)data, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
    }

    public ResponseEntity<?> findStoredFilesByFolder(String folder) {
        List listStoresPaths = this.findIdByFolder(folder).stream().map(id -> this.apiDomainUrl + "/v1/stored-file/assets/" + String.valueOf(id)).collect(Collectors.toList());
        return TransactionCustom.ok(listStoresPaths);
    }

    public void deleteById(UUID idFile) {
        this.storedFileDAO.deleteById((Object)idFile);
    }

    public List<TStoredFile> findStoredFileCreatedInTheLastDays(Date daysAgo, String folder) {
        return this.storedFileDAO.findStoredFileCreatedInTheLastDays(daysAgo, folder);
    }
}

