/*
 * Decompiled with CFR 0.152.
 */
package io.tws2.back_file_bot.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="t_stored_file")
public class TStoredFile {
    @Id
    @Column(nullable=false)
    private UUID id;
    @Column(name="file_year", nullable=false)
    private int fileYear;
    @Column(name="file_month", nullable=false)
    private int fileMonth;
    @Column(name="file_data", nullable=false)
    private byte[] fileData;
    @Column(name="content_type")
    private String contentType;
    @Column(name="folder")
    private String folder;
    @Column(name="file_id")
    private String fileId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.createdAt);
        this.fileYear = calendar.get(1);
        this.fileMonth = calendar.get(2) + 1;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public int getFileYear() {
        return this.fileYear;
    }

    public void setFileYear(int fileYear) {
        this.fileYear = fileYear;
    }

    public int getFileMonth() {
        return this.fileMonth;
    }

    public void setFileMonth(int fileMonth) {
        this.fileMonth = fileMonth;
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }
}

