/*
 * Decompiled with CFR 0.152.
 */
package io.tws2.back_file_bot.controller;

import io.tws2.back_file_bot.dto.StoredFileDTO;
import io.tws2.back_file_bot.service.StoredFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/stored-file"})
public class StoredFileController {
    @Autowired
    private StoredFileService storedFileService;

    @GetMapping(value={"assets/{fileId:.+}"})
    public ResponseEntity<byte[]> getByteFileById(@PathVariable String fileId, @RequestHeader(value="Range", required=false) String rangeHeader, @RequestParam(required=false, defaultValue="false") boolean whatsappVideo) {
        return this.storedFileService.getByteFileById(fileId, rangeHeader, whatsappVideo);
    }

    @GetMapping(value={"assets/folder/{folder}"})
    public ResponseEntity<?> getFilesByFolder(@PathVariable(required=false) String folder) {
        if (folder == null) {
            return ResponseEntity.status((int)401).build();
        }
        return this.storedFileService.findStoredFilesByFolder(folder);
    }

    @PostMapping(value={"save"})
    public ResponseEntity<?> save(@RequestBody StoredFileDTO storedFileDTO) {
        return this.storedFileService.saveStoredFile(storedFileDTO);
    }

    @GetMapping(value={"test"})
    public String getTest() {
        return "OK";
    }
}

