/*
 * Decompiled with CFR 0.152.
 */
package io.tws2.back_file_bot.common.util;

import io.tws2.back_file_bot.common.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Base64;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    public static final String FILE_TYPE_PDF = "application/pdf";
    public static final String FILE_TYPE_PNG = "image/png";
    public static final String FILE_TYPE_JPEG = "image/jpeg";

    public static String determineFileType(String typeFile) {
        if (typeFile == null || typeFile.isEmpty()) {
            return null;
        }
        if (typeFile.equals("png") || typeFile.equals("image/png")) {
            return "image/png";
        }
        if (typeFile.equals("pdf") || typeFile.equals("application/pdf")) {
            return "application/pdf";
        }
        if (typeFile.equals("jpg") || typeFile.equals("jpeg") || typeFile.equals("image/jpeg")) {
            return "image/jpeg";
        }
        return typeFile;
    }

    public static byte[] base64ToByte(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static String resolveMime(String storedContentType, byte[] data) {
        String mime = FileUtil.resolveMimeWithoutFilename((String)storedContentType, (byte[])data);
        if (mime == null || mime.isBlank()) {
            mime = "application/octet-stream";
        }
        try {
            if (FileUtil.looksLikeMp4((byte[])data) && !"video/mp4".equalsIgnoreCase(mime)) {
                mime = "video/mp4";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mime;
    }

    public static HttpHeaders buildInlineHeaders(String mime, String fileId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)mime));
        headers.set("Accept-Ranges", "bytes");
        headers.setContentDisposition(ContentDisposition.inline().filename(fileId + FileUtil.guessExt((String)mime)).build());
        headers.setCacheControl("public, max-age=2592000");
        return headers;
    }

    public static String guessExt(String mime) {
        String m = mime.toLowerCase();
        if (m.equals("application/pdf")) {
            return ".pdf";
        }
        if (m.equals("image/png")) {
            return ".png";
        }
        if (m.equals("image/jpeg")) {
            return ".jpg";
        }
        if (m.equals("image/gif")) {
            return ".gif";
        }
        if (m.equals("audio/mpeg")) {
            return ".mp3";
        }
        if (m.equals("audio/wav")) {
            return ".wav";
        }
        if (m.equals("audio/ogg")) {
            return ".ogg";
        }
        if (m.equals("audio/mp4") || m.equals("audio/aac") || m.equals("audio/m4a")) {
            return ".m4a";
        }
        if (m.equals("video/mp4")) {
            return ".mp4";
        }
        if (m.equals("video/webm")) {
            return ".webm";
        }
        if (m.equals("video/ogg")) {
            return ".ogv";
        }
        return "";
    }

    public static boolean shouldUseRange(boolean useRange, String rangeHeader) {
        if (!useRange) {
            return false;
        }
        return rangeHeader != null && rangeHeader.startsWith("bytes=");
    }

    public static Range parseRange(String rangeHeader, long total) {
        long end;
        long start;
        String rv = rangeHeader.substring("bytes=".length()).trim();
        if (rv.startsWith("-")) {
            long suffix = FileUtil.parseLongSafe((String)rv.substring(1), (long)-1L);
            if (suffix <= 0L) {
                return new Range(-1L, -1L, total);
            }
            start = Math.max(total - suffix, 0L);
            end = total - 1L;
        } else if (rv.endsWith("-")) {
            start = FileUtil.parseLongSafe((String)rv.substring(0, rv.length() - 1), (long)-1L);
            if (start < 0L) {
                return new Range(-1L, -1L, total);
            }
            end = total - 1L;
        } else {
            String[] p = rv.split("-", 2);
            if (p.length != 2) {
                return new Range(-1L, -1L, total);
            }
            start = FileUtil.parseLongSafe((String)p[0], (long)-1L);
            end = FileUtil.parseLongSafe((String)p[1], (long)-1L);
            if (start < 0L || end < 0L) {
                return new Range(-1L, -1L, total);
            }
        }
        if (start >= total) {
            return new Range(-1L, -1L, total);
        }
        end = Math.min(end, total - 1L);
        return new Range(start, end, total);
    }

    public static long parseLongSafe(String s, long def) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static byte[] slice(byte[] data, long start, long end) {
        int iStart = (int)start;
        int iEndExclusive = (int)(end + 1L);
        return Arrays.copyOfRange(data, iStart, iEndExclusive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resolveMimeWithoutFilename(String storedContentType, byte[] data) {
        if (storedContentType != null && !storedContentType.isBlank()) {
            try {
                return MediaType.parseMediaType((String)storedContentType).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FileUtil.looksLikePdf((byte[])data)) {
            return "application/pdf";
        }
        if (FileUtil.looksLikePng((byte[])data)) {
            return "image/png";
        }
        if (FileUtil.looksLikeJpeg((byte[])data)) {
            return "image/jpeg";
        }
        if (FileUtil.looksLikeMp3((byte[])data)) {
            return "audio/mpeg";
        }
        if (FileUtil.looksLikeWav((byte[])data)) {
            return "audio/wav";
        }
        if (FileUtil.looksLikeOgg((byte[])data)) {
            return "audio/ogg";
        }
        if (FileUtil.looksLikeMp4((byte[])data)) {
            return "video/mp4";
        }
        if (FileUtil.looksLikeWebm((byte[])data)) {
            return "video/webm";
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            String guess = URLConnection.guessContentTypeFromStream(is);
            if (guess == null) return "application/octet-stream";
            String string = guess;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "application/octet-stream";
    }

    public static boolean looksLikePdf(byte[] b) {
        return b.length > 5 && b[0] == 37 && b[1] == 80 && b[2] == 68 && b[3] == 70 && b[4] == 45;
    }

    public static boolean looksLikePng(byte[] b) {
        byte[] sig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (b.length < sig.length) {
            return false;
        }
        for (int i = 0; i < sig.length; ++i) {
            if (b[i] == sig[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean looksLikeJpeg(byte[] b) {
        return b.length > 3 && (b[0] & 0xFF) == 255 && (b[1] & 0xFF) == 216 && (b[b.length - 2] & 0xFF) == 255 && (b[b.length - 1] & 0xFF) == 217;
    }

    public static boolean looksLikeMp3(byte[] b) {
        if (b.length >= 3 && b[0] == 73 && b[1] == 68 && b[2] == 51) {
            return true;
        }
        return b.length >= 2 && (b[0] & 0xFF) == 255 && (b[1] & 0xE0) == 224;
    }

    public static boolean looksLikeWav(byte[] b) {
        return b.length >= 12 && b[0] == 82 && b[1] == 73 && b[2] == 70 && b[3] == 70 && b[8] == 87 && b[9] == 65 && b[10] == 86 && b[11] == 69;
    }

    public static boolean looksLikeOgg(byte[] b) {
        return b.length >= 4 && b[0] == 79 && b[1] == 103 && b[2] == 103 && b[3] == 83;
    }

    public static boolean looksLikeMp4(byte[] b) {
        if (b.length < 12) {
            return false;
        }
        for (int i = 4; i <= 32 && i + 3 < b.length; ++i) {
            if (b[i] != 102 || b[i + 1] != 116 || b[i + 2] != 121 || b[i + 3] != 112) continue;
            return true;
        }
        return false;
    }

    public static boolean looksLikeWebm(byte[] b) {
        return b.length >= 4 && (b[0] & 0xFF) == 26 && (b[1] & 0xFF) == 69 && (b[2] & 0xFF) == 223 && (b[3] & 0xFF) == 163;
    }
}

