/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.dto.BusinessPhoneDTO;
import com.whatsapp.campaign.entity.TBusinessPhone;
import com.whatsapp.campaign.exceptions.CustomException;
import com.whatsapp.campaign.mappers.PhoneBusinessMapper;
import com.whatsapp.campaign.repository.BusinessPhoneDAO;
import com.whatsapp.campaign.service.RegisterPhoneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class RegisterPhoneServiceImpl
implements RegisterPhoneService {
    private static final Logger log = LoggerFactory.getLogger(RegisterPhoneServiceImpl.class);
    private final BusinessPhoneDAO businessPhoneDAO;

    public Mono<TBusinessPhone> findBusinessPhonebyPhoneIdentifier(String phoneIdentifier) {
        log.info("Finding business phone by phone identifier: {}", (Object)phoneIdentifier);
        return this.businessPhoneDAO.findByPhoneId(phoneIdentifier);
    }

    public Mono<String> saveOrUpdateBusinessPhone(BusinessPhoneDTO businessPhone) {
        log.info("Saving or updating business phone: {}", (Object)businessPhone);
        return this.findBusinessPhonebyPhoneIdentifier(businessPhone.getPhoneId()).switchIfEmpty(Mono.deferContextual(ctx -> {
            log.info("No existing business phone found, creating a new one.");
            return Mono.just((Object)PhoneBusinessMapper.mapToBusinessPhone((BusinessPhoneDTO)businessPhone));
        })).flatMap(existingPhone -> this.businessPhoneDAO.save((Object)PhoneBusinessMapper.mapToBusinessPhoneForUpdate((TBusinessPhone)existingPhone, (BusinessPhoneDTO)businessPhone)).flatMap(saved -> Mono.just((Object)"Business phone saved or updated successfully"))).onErrorResume(err -> Mono.error((Throwable)new CustomException(err.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR)));
    }

    public RegisterPhoneServiceImpl(BusinessPhoneDAO businessPhoneDAO) {
        this.businessPhoneDAO = businessPhoneDAO;
    }
}

