/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.service.impl;

import com.whatsapp.campaign.dto.ChannelsDTO;
import com.whatsapp.campaign.entity.Channels;
import com.whatsapp.campaign.mappers.ChannelsMapper;
import com.whatsapp.campaign.repository.ChannelsDAO;
import com.whatsapp.campaign.service.ChannelsService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ChannelsServiceImpl
implements ChannelsService {
    private static final Logger log = LoggerFactory.getLogger(ChannelsServiceImpl.class);
    private final ChannelsDAO channelsDAO;

    public Mono<List<Channels>> findAllChannels() {
        return this.channelsDAO.findAll().collectList().flatMap(instances -> Mono.just((Object)instances));
    }

    public Mono<Void> saveChannels(ChannelsDTO channel) {
        return this.channelsDAO.save((Object)ChannelsMapper.mapToChannels((ChannelsDTO)channel)).doOnNext(saved -> log.info("Guardado: {}", saved)).then();
    }

    public ChannelsServiceImpl(ChannelsDAO channelsDAO) {
        this.channelsDAO = channelsDAO;
    }
}

