/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.config.ApiResponse;
import com.whatsapp.campaign.dto.BusinessPhoneDTO;
import com.whatsapp.campaign.service.InstanceService;
import com.whatsapp.campaign.service.RegisterPhoneService;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/instance"})
public class InstanceController {
    private static final Logger log = LoggerFactory.getLogger(InstanceController.class);
    private final RegisterPhoneService registerPhoneService;
    private final InstanceService instanceService;

    @GetMapping(value={"/list"})
    @PreAuthorize(value="hasRole('SUPERADMIN')")
    public Mono<ResponseEntity<?>> getAvaliableInstances() {
        return this.instanceService.getAvailableInstances().flatMap(instances -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)instances))));
    }

    @PostMapping(value={"/notify-registration"})
    public Mono<ResponseEntity<?>> updateStatusMessage(@RequestBody @Valid BusinessPhoneDTO businessPhoneDTO) {
        return this.registerPhoneService.saveOrUpdateBusinessPhone(businessPhoneDTO).flatMap(response -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.okMessage((String)response))));
    }

    public InstanceController(RegisterPhoneService registerPhoneService, InstanceService instanceService) {
        this.registerPhoneService = registerPhoneService;
        this.instanceService = instanceService;
    }
}

