/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.campaign.controller;

import com.whatsapp.campaign.config.ApiResponse;
import com.whatsapp.campaign.dto.ChannelsDTO;
import com.whatsapp.campaign.service.ChannelsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/channels"})
public class ChannelsController {
    private static final Logger log = LoggerFactory.getLogger(ChannelsController.class);
    private final ChannelsService channelsService;

    @GetMapping
    @PreAuthorize(value="hasRole('SUPERADMIN')")
    public Mono<ResponseEntity<?>> getChannels() {
        return this.channelsService.findAllChannels().flatMap(instances -> Mono.just((Object)ResponseEntity.ok((Object)ApiResponse.ok((Object)instances))));
    }

    @PostMapping
    @PreAuthorize(value="hasRole('SUPERADMIN')")
    public Mono<ResponseEntity<Void>> postChannels(@RequestBody ChannelsDTO channel) {
        return this.channelsService.saveChannels(channel).thenReturn((Object)ResponseEntity.ok().build());
    }

    public ChannelsController(ChannelsService channelsService) {
        this.channelsService = channelsService;
    }
}

